/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.List;
import java.util.UUID;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.property.Path;

@NotThreadSafe
public abstract class PathWorkspace<NodeType extends PathNode>
implements Workspace {
    private final String name;
    private final UUID rootNodeUuid;

    public PathWorkspace(String name, UUID rootNodeUuid) {
        this.name = name;
        this.rootNodeUuid = rootNodeUuid;
        assert (this.name != null);
        assert (this.rootNodeUuid != null);
    }

    public PathWorkspace(String name, PathWorkspace<NodeType> originalToClone) {
        this.name = name;
        this.rootNodeUuid = ((PathNode)originalToClone.getRootNode()).getUuid();
        assert (this.name != null);
        assert (this.rootNodeUuid != null);
        throw new UnsupportedOperationException("Need to implement the ability to clone a workspace");
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public abstract NodeType getRootNode();

    public abstract NodeType getNode(Path var1);

    public Location verifyNodeExists(Path path) {
        NodeType node = this.getNode(path);
        return node != null ? Location.create(path) : null;
    }

    public NodeType putNode(NodeType node) {
        throw new UnsupportedOperationException();
    }

    public NodeType moveNode(NodeType source, NodeType target) {
        throw new UnsupportedOperationException();
    }

    public NodeType removeNode(Path path) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.name;
    }

    public void commit(List<ChangeCommand<NodeType>> commands) {
        for (ChangeCommand<NodeType> command : commands) {
            command.apply();
        }
    }

    public ChangeCommand<NodeType> createPutCommand(NodeType oldNode, NodeType node) {
        return new PutCommand(this, node);
    }

    public ChangeCommand<NodeType> createRemoveCommand(Path path) {
        return new RemoveCommand(path);
    }

    public ChangeCommand<NodeType> createMoveCommand(NodeType source, NodeType target) {
        return new MoveCommand(this, source, target);
    }

    private static class MoveCommand
    implements ChangeCommand<NodeType> {
        private NodeType node;
        private NodeType newNode;
        final /* synthetic */ PathWorkspace this$0;

        protected MoveCommand(NodeType node, NodeType newNode) {
            this.this$0 = var1_1;
            this.node = node;
            this.newNode = newNode;
        }

        @Override
        public void apply() {
            this.this$0.moveNode(this.node, this.newNode);
        }

        public String toString() {
            return "Move: { " + this.node + " to " + this.newNode + "}";
        }
    }

    private class RemoveCommand
    implements ChangeCommand<NodeType> {
        private Path path;

        protected RemoveCommand(Path path) {
            this.path = path;
        }

        @Override
        public void apply() {
            PathWorkspace.this.removeNode(this.path);
        }

        public String toString() {
            return "Remove: { " + this.path.getString() + "}";
        }
    }

    private static class PutCommand
    implements ChangeCommand<NodeType> {
        private NodeType node;
        final /* synthetic */ PathWorkspace this$0;

        protected PutCommand(NodeType node) {
            this.this$0 = var1_1;
            this.node = node;
        }

        @Override
        public void apply() {
            this.this$0.putNode(this.node);
        }

        public String toString() {
            return "Put: { " + this.node + "}";
        }
    }

    public static interface ChangeCommand<NodeType extends PathNode> {
        public void apply();
    }
}

