/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public final class DestroyWorkspaceRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final String workspaceName;
    private Location actualLocationOfRoot;

    public DestroyWorkspaceRequest(String workspaceName) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
    }

    public String workspaceName() {
        return this.workspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.checkNotFrozen();
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public int hashCode() {
        return this.workspaceName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            DestroyWorkspaceRequest that = (DestroyWorkspaceRequest)obj;
            return this.workspaceName.equals(that.workspaceName());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName() != null ? "'" + this.workspaceName() + "'" : "default";
        return "destroy workspace " + workspaceName;
    }

    @Override
    public Location changedLocation() {
        return this.actualLocationOfRoot;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName().equals(workspace);
    }

    @Override
    public DestroyWorkspaceRequest clone() {
        return new DestroyWorkspaceRequest(this.workspaceName);
    }

    @Override
    public RequestType getType() {
        return RequestType.DESTROY_WORKSPACE;
    }
}

