/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.ArrayListMultimap;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.XmiGraphReader;

public class CndFromEcore {
    private static final char NEWLINE = '\n';
    @Parameter(description="Comma-separated list of Ecore input file paths or URLs")
    private List<String> ecoreFileNames = new ArrayList<String>();
    @Parameter(names={"-o", "-out"}, description="Name of the CND output file")
    private String cndFileName;
    @Parameter(names={"-debug"}, description="Debug mode")
    private boolean debug = false;
    @Parameter(names={"-mixin"}, description="EClasses are converted to node types")
    private boolean mixins = false;
    @Parameter(names={"-shortNames"}, description="Generate shorter names where possible")
    private boolean shortNames = false;
    private Problems problems = new SimpleProblems();

    public static void main(String[] args) {
        CndFromEcore converter = new CndFromEcore();
        JCommander commander = new JCommander((Object)converter, args);
        if (!converter.isValid()) {
            commander.usage();
        } else {
            converter.execute();
            if (converter.getProblems().hasProblems()) {
                System.out.println(converter.getProblems());
            }
        }
    }

    public List<String> getEcoreFileNames() {
        return this.ecoreFileNames;
    }

    public void setEcoreFileNames(List<String> ecoreFileNames) {
        this.ecoreFileNames = ecoreFileNames;
    }

    public void setEcoreFileNames(String ... ecoreFileNames) {
        this.ecoreFileNames = new ArrayList<String>(Arrays.asList(ecoreFileNames));
    }

    public String getCndFileName() {
        return this.cndFileName;
    }

    public void setCndFileName(String cndFileName) {
        this.cndFileName = cndFileName;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean generatesMixins() {
        return this.mixins;
    }

    public void setGeneratesMixins(boolean mixins) {
        this.mixins = mixins;
    }

    public boolean generateShortNames() {
        return this.shortNames;
    }

    public void setGeneratesShortNames(boolean shortNames) {
        this.shortNames = shortNames;
    }

    public boolean isValid() {
        return !this.ecoreFileNames.isEmpty();
    }

    public Problems getProblems() {
        return this.problems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ExecutionContext context = new ExecutionContext();
        NamespaceRegistry registry = context.getNamespaceRegistry();
        LocalNamespaceRegistry localRegistry = new LocalNamespaceRegistry(registry);
        context = context.with((NamespaceRegistry)localRegistry);
        ArrayList<String> ecoreFileContributions = new ArrayList<String>();
        for (String ecoreFileName : this.getEcoreFileNames()) {
            String ecoreName = ecoreFileName.replace("\\.ecore", "");
            this.debug(TeiidI18n.readingEcoreFile, ecoreFileName);
            StringBuilder sb = new StringBuilder();
            try {
                InMemoryRepositorySource source = new InMemoryRepositorySource();
                source.setName(ecoreName);
                Graph graph = Graph.create((RepositorySource)source, (ExecutionContext)context);
                graph.importXmlFrom(ecoreFileName).into("/");
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(20).at("/ecore:EPackage");
                CndGraphReader reader = new CndGraphReader(subgraph, this.generatesMixins(), this.generateShortNames());
                reader.writeTo(sb);
                ecoreFileContributions.add(sb.toString());
            }
            catch (Throwable t) {
                this.problems.addError(TeiidI18n.errorReadingEcoreFile, new Object[]{ecoreFileName, t.getLocalizedMessage()});
            }
        }
        StringBuilder output = new StringBuilder();
        output.append(this.getHeader());
        for (NamespaceRegistry.Namespace namespace : localRegistry.getLocalNamespaces()) {
            this.write(output, namespace);
        }
        output.append('\n');
        for (String contribution : ecoreFileContributions) {
            output.append(contribution);
            output.append('\n');
        }
        if (this.cndFileName != null && this.cndFileName.trim().length() != 0) {
            try {
                FileWriter writer = new FileWriter(this.cndFileName);
                writer.close();
            }
            catch (Throwable t) {
                this.problems.addError(TeiidI18n.errorWritingCndFile, new Object[]{this.cndFileName, t.getLocalizedMessage()});
            }
        } else {
            System.out.println(output);
        }
    }

    protected void write(StringBuilder writer, NamespaceRegistry.Namespace namespace) {
        writer.append("<").append(namespace.getPrefix()).append("='").append(namespace.getNamespaceUri()).append("'>").append('\n');
    }

    protected String getHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*").append('\n');
        sb.append(" * Generated using the ").append(this.getClass().getCanonicalName()).append(" program.").append('\n');
        sb.append(" *").append('\n');
        sb.append(" */").append('\n');
        return sb.toString();
    }

    protected void debug(I18n msg, Object ... params) {
        if (this.isDebug()) {
            System.out.println(msg.text(params));
        }
    }

    protected static class CndGraphReader
    extends XmiGraphReader {
        private final boolean generateMixins;

        protected CndGraphReader(Subgraph subgraph, boolean generateMixins, boolean generateShortNames) {
            super(subgraph, generateShortNames);
            this.generateMixins = generateMixins;
        }

        protected void writeTo(StringBuilder sb) {
            String type;
            SubgraphNode classifier;
            SubgraphNode pkg = this.subgraph.getRoot();
            String pkgName = this.inflector.titleCase(this.firstValue((Node)pkg, "name"), new String[0]);
            String uri = this.firstValue((Node)pkg, "nsURI");
            String prefix = this.namespacePrefix(this.firstValue((Node)pkg, "nsPrefix"));
            sb.append("// -------------------------------------------").append('\n');
            sb.append("// ").append(pkgName).append('\n');
            sb.append("// -------------------------------------------").append('\n');
            this.namespaces.register(prefix, uri);
            this.setCurrentNamespaceUri(uri);
            ArrayListMultimap literalsByEnumName = ArrayListMultimap.create();
            for (Location child : pkg.getChildren()) {
                classifier = pkg.getNode(child.getPath().getLastSegment());
                type = this.firstValue((Node)classifier, "xsi:type");
                if (!"ecore:EEnum".equals(type)) continue;
                Name enumName = this.nameFrom(this.firstValue((Node)classifier, "name"));
                for (Location feature : classifier.getChildren()) {
                    SubgraphNode literal = classifier.getNode(feature.getPath().getLastSegment());
                    String literalValue = this.firstValue((Node)literal, "name");
                    literalsByEnumName.put((Object)enumName, (Object)literalValue);
                }
            }
            for (Location child : pkg.getChildren()) {
                classifier = pkg.getNode(child.getPath().getLastSegment());
                type = this.firstValue((Node)classifier, "xsi:type");
                if ("ecore:EEnum".equals(type)) continue;
                Name nodeTypeName = this.nameFrom(this.firstValue((Node)classifier, "name"));
                boolean isAbstract = this.firstValue((Node)classifier, "abstract", false);
                List<Name> supertypes = this.names((Node)classifier, "eSuperTypes", "\\s");
                sb.append("[").append(this.stringFrom(nodeTypeName)).append("] ");
                if (!supertypes.isEmpty()) {
                    sb.append("> ");
                    boolean first = true;
                    for (Name supertype : supertypes) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(",");
                        }
                        sb.append(this.stringFrom(supertype)).append(" ");
                    }
                }
                if (isAbstract) {
                    sb.append("abstract ");
                }
                if (this.generateMixins) {
                    sb.append("mixin ");
                }
                for (Location feature : classifier.getChildren()) {
                    SubgraphNode structuralFeature = classifier.getNode(feature.getPath().getLastSegment());
                    String featureType = this.firstValue((Node)structuralFeature, "xsi:type");
                    Name featureName = this.nameFrom(this.firstValue((Node)structuralFeature, "name"));
                    long upperBound = this.firstValue((Node)structuralFeature, "upperBound", 1L);
                    long lowerBound = this.firstValue((Node)structuralFeature, "lowerBound", 0L);
                    boolean isSingle = upperBound == 1L;
                    boolean isRequired = lowerBound > 0L;
                    boolean isReference = "ecore:EReference".equals(featureType);
                    boolean isTransient = this.firstValue((Node)structuralFeature, "transient", false);
                    boolean isContainment = this.firstValue((Node)structuralFeature, "containment", false);
                    boolean isUnsettable = this.firstValue((Node)structuralFeature, "unsettable", false);
                    boolean isVolatile = this.firstValue((Node)structuralFeature, "volatile", false);
                    boolean isChangeble = this.firstValue((Node)structuralFeature, "changeable", true);
                    Name dataType = this.nameFrom(this.firstValue((Node)structuralFeature, "eType"));
                    String defaultValue = this.firstValue((Node)structuralFeature, "defaultValueLiteral");
                    String jcrType = this.jcrTypeNameFor(dataType);
                    Collection constraints = literalsByEnumName.get((Object)dataType);
                    if (!constraints.isEmpty()) {
                        jcrType = "STRING";
                    }
                    if (isContainment) {
                        boolean x = false;
                        continue;
                    }
                    String propDefnName = this.stringFrom(featureName);
                    sb.append('\n');
                    sb.append(" - ").append(propDefnName).append(" (").append(jcrType).append(") ");
                    if (defaultValue != null) {
                        sb.append("= '").append(defaultValue).append("' ");
                    }
                    if (isRequired) {
                        sb.append("mandatory ");
                    }
                    if (!isSingle) {
                        sb.append("multiple ");
                    }
                    if (!isChangeble) {
                        sb.append("protected autocreated");
                    }
                    if (constraints.isEmpty()) continue;
                    sb.append('\n');
                    sb.append("   < ");
                    boolean first = true;
                    for (String constraint : constraints) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append("'").append(constraint).append("'");
                    }
                }
                sb.append('\n');
                sb.append('\n');
            }
        }
    }
}

