/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.DataSourceFactory;
import org.semanticdesktop.aperture.datasource.DataSourceRegistry;
import org.semanticdesktop.aperture.util.ontology.OntologyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceRegistryImpl
implements DataSourceRegistry {
    private HashMap factories = new HashMap();

    public void add(DataSourceFactory dataSourceFactory) {
        if (dataSourceFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        URI uRI = dataSourceFactory.getSupportedType();
        HashSet<DataSourceFactory> hashSet = (HashSet<DataSourceFactory>)this.factories.get(uRI);
        if (hashSet == null) {
            hashSet = new HashSet<DataSourceFactory>();
            this.factories.put(uRI, hashSet);
        }
        hashSet.add(dataSourceFactory);
    }

    public void remove(DataSourceFactory dataSourceFactory) {
        URI uRI = dataSourceFactory.getSupportedType();
        Set set = (Set)this.factories.get(uRI);
        if (set != null) {
            set.remove(dataSourceFactory);
            if (set.isEmpty()) {
                this.factories.remove(uRI);
            }
        }
    }

    public Set get(URI uRI) {
        Set set = (Set)this.factories.get(uRI);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(set);
    }

    public Set getAll() {
        HashSet hashSet = new HashSet();
        for (Set set : this.factories.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public void getDataSourceOntologyAndDescriptions(Model model) {
        try {
            OntologyUtil.getSourceFormatOntology(model);
            OntologyUtil.getSourceOntology(model);
            for (Set set : this.factories.values()) {
                for (Object e : set) {
                    DataSourceFactory dataSourceFactory = (DataSourceFactory)e;
                    dataSourceFactory.getDescription(model);
                }
            }
        }
        catch (Exception exception) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Could not get data source ontology and descriptions", (Throwable)exception);
        }
    }
}

