/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.outlook;

import java.io.IOException;
import java.util.Map;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.outlook.OutlookCrawler;
import org.semanticdesktop.aperture.outlook.OutlookDataSource;
import org.semanticdesktop.aperture.outlook.OutlookResource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookAccessor
implements DataAccessor {
    public static final String PARAM_OUTLOOKRESOURCE = "ol_resource";
    public static final String PARAM_OUTLOOKPARENT = "ol_parent";
    public static final String PARAM_MAPI = "ol_mapi";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DataObject getDataObject(String string, DataSource dataSource, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        OutlookResource outlookResource = null;
        OutlookResource outlookResource2 = null;
        if (map != null) {
            outlookResource = (OutlookResource)map.get(PARAM_OUTLOOKRESOURCE);
            outlookResource2 = (OutlookResource)map.get(PARAM_OUTLOOKPARENT);
        }
        return this.getDataObjectIfModifiedOutlook(string, dataSource, null, map, rDFContainerFactory, outlookResource, outlookResource2);
    }

    public DataObject getDataObjectIfModified(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        OutlookResource outlookResource = null;
        OutlookResource outlookResource2 = null;
        if (map != null) {
            outlookResource = (OutlookResource)map.get(PARAM_OUTLOOKRESOURCE);
            outlookResource2 = (OutlookResource)map.get(PARAM_OUTLOOKPARENT);
        }
        return this.getDataObjectIfModifiedOutlook(string, dataSource, accessData, map, rDFContainerFactory, outlookResource, outlookResource2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObjectIfModifiedOutlook(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory, OutlookResource outlookResource, OutlookResource outlookResource2) throws UrlNotFoundException, IOException {
        this.logger.info("get data of " + string);
        OutlookCrawler outlookCrawler = null;
        boolean bl = false;
        try {
            Object object;
            if (outlookResource == null) {
                outlookCrawler = new OutlookCrawler();
                if (dataSource == null) {
                    dataSource = this.createDummyDataSource(string);
                    bl = true;
                }
                outlookCrawler.setDataSource(dataSource);
                outlookCrawler.beginCall();
                outlookResource = OutlookResource.createWrapperFor(outlookCrawler, string, this.logger);
                if (outlookResource == null) {
                    throw new UrlNotFoundException(string, "cannot crawl " + string + ", not found in Outlook.");
                }
            }
            if (accessData != null) {
                long l = outlookResource.getLastModified();
                object = accessData.get(string, "date");
                if (object != null) {
                    long l2;
                    block17: {
                        l2 = Long.parseLong((String)object);
                        if (l2 != l) break block17;
                        this.logger.info(string + " not modified - reg:" + l2);
                        DataObject dataObject = null;
                        return dataObject;
                    }
                    try {
                        this.logger.info(string + " was modified - reg:" + l2 + " new:" + l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logger.warn("illegal long: " + (String)object, (Throwable)numberFormatException);
                    }
                }
                accessData.put(string, "date", String.valueOf(l));
            }
            URI uRI = URIImpl.createURIWithoutChecking((String)string);
            RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer(uRI);
            rDFContainer.add(RDF.type, (Node)outlookResource.getType());
            if (outlookResource2 != null) {
                object = new URIImpl(outlookResource2.getUri());
                rDFContainer.add(NIE.isPartOf, (Node)object);
                rDFContainer.add(rDFContainer.getModel().createStatement((Resource)object, RDF.type, (Node)NIE.InformationElement));
            } else {
                rDFContainer.add(NIE.rootElementOf, (Node)dataSource.getID());
            }
            outlookResource.addData(rDFContainer);
            object = null;
            object = outlookResource.isFolder() ? new FolderDataObjectBase(uRI, dataSource, rDFContainer) : new DataObjectBase(uRI, dataSource, rDFContainer);
            Object object2 = object;
            return object2;
        }
        finally {
            if (outlookCrawler != null) {
                outlookCrawler.endCall();
                outlookCrawler.release();
                if (outlookResource != null) {
                    outlookResource.release();
                }
                if (bl) {
                    dataSource.getConfiguration().dispose();
                }
            }
        }
    }

    private DataSource createDummyDataSource(String string) {
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        RDFContainerImpl rDFContainerImpl = new RDFContainerImpl(model, string);
        OutlookDataSource outlookDataSource = new OutlookDataSource();
        outlookDataSource.setConfiguration(rDFContainerImpl);
        return outlookDataSource;
    }
}

