/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    private static Logger log = LoggerFactory.getLogger(ModelUtil.class);

    public static Literal createLiteral(Model model, String string) throws ModelException {
        return model.createPlainLiteral(string);
    }

    public static Literal createLiteral(Model model, String string, URI uRI) throws ModelException {
        return model.createDatatypeLiteral(string, uRI);
    }

    public static Literal createLiteral(Model model, boolean bl) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(bl), XSD._boolean);
    }

    public static Literal createLiteral(Model model, long l) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(l), XSD._long);
    }

    public static Literal createLiteral(Model model, int n) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(n), XSD._integer);
    }

    public static Literal createLiteral(Model model, short s) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(s), XSD._short);
    }

    public static Literal createLiteral(Model model, byte by) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(by), XSD._byte);
    }

    public static Literal createLiteral(Model model, double d) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(d), XSD._double);
    }

    public static Literal createLiteral(Model model, float f) throws ModelException {
        return model.createDatatypeLiteral(String.valueOf(f), XSD._float);
    }

    public static Statement createStatement(Model model, Resource resource, URI uRI, Node node) {
        return model.createStatement(resource, uRI, node);
    }

    public static URI createURI(Model model, String string) throws ModelException {
        return model.createURI(string);
    }

    public static URI createURI(Model model, String string, String string2) throws ModelException {
        return ModelUtil.createURI(model, string + "#" + string2);
    }

    public static BlankNode createBlankNode(Model model) {
        return model.createBlankNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Statement> getCBD(Resource resource, Model model, boolean bl) throws ModelException {
        Vector<Statement> vector = new Vector<Statement>();
        ClosableIterator closableIterator = null;
        try {
            Statement statement;
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                statement = (Statement)closableIterator.next();
                vector.add(statement);
                if (!(statement.getObject() instanceof BlankNode)) continue;
                vector.addAll(ModelUtil.getCBD((Resource)statement.getObject(), model, bl));
            }
            closableIterator.close();
            if (bl) {
                closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)Variable.ANY, (NodeOrVariable)resource);
                while (closableIterator.hasNext()) {
                    statement = (Statement)closableIterator.next();
                    vector.add(statement);
                    if (!(statement.getSubject() instanceof BlankNode)) continue;
                    vector.addAll(ModelUtil.getCBD((Resource)statement.getObject(), model, bl));
                }
                closableIterator.close();
            }
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasStatement(Model model, Resource resource, URI uRI, Node node) throws ModelException {
        boolean bl = false;
        ClosableIterator closableIterator = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)uRI, (NodeOrVariable)node);
            bl = closableIterator.hasNext();
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource getSingleSubjectWithProperty(Model model, URI uRI, Node node) {
        Resource resource;
        if (model == null || uRI == null || node == null) {
            throw new NullPointerException("All parameters of the getSingleSubjectWithProperty method must be non-null");
        }
        ClosableIterator closableIterator = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)uRI, (NodeOrVariable)node);
            if (!closableIterator.hasNext()) {
                throw new ModelException("There are no subjects for property: " + uRI + " object: " + node);
            }
            Statement statement = (Statement)closableIterator.next();
            if (closableIterator.hasNext()) {
                throw new ModelException("There are multiple subjects for the given property");
            }
            resource = statement.getSubject().asResource();
        }
        catch (ModelException modelException) {
            try {
                log.warn("Couldn't get the subject for the given property", (Throwable)modelException);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(closableIterator);
                throw throwable;
            }
            ModelUtil.closeClosable(closableIterator);
            return null;
        }
        ModelUtil.closeClosable(closableIterator);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Resource> getAllSubjectsWithProperty(Model model, URI uRI, Node node) {
        Statement statement;
        if (model == null || uRI == null || node == null) {
            throw new NullPointerException("All parameters of the getSingleSubjectWithProperty method must be non-null");
        }
        ClosableIterator closableIterator = null;
        Statement statement2 = new LinkedList();
        try {
            closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)uRI, (NodeOrVariable)node);
            while (closableIterator.hasNext()) {
                statement = (Statement)closableIterator.next();
                statement2.add(statement.getSubject());
            }
            statement = statement2;
        }
        catch (Throwable throwable) {
            ModelUtil.closeClosable(closableIterator);
            throw throwable;
        }
        ModelUtil.closeClosable(closableIterator);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node getPropertyValue(Model model, Resource resource, URI uRI) {
        Node node;
        ClosableIterator closableIterator;
        block6: {
            if (model == null || resource == null || uRI == null) {
                throw new NullPointerException("All arguments of the getPropertyValue method must be non-null");
            }
            closableIterator = null;
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            if (closableIterator.hasNext()) break block6;
            Node node2 = null;
            ModelUtil.closeClosable(closableIterator);
            return node2;
        }
        try {
            Statement statement = (Statement)closableIterator.next();
            node = statement.getObject();
        }
        catch (ModelRuntimeException modelRuntimeException) {
            try {
                log.warn("Couldn't get the subject for the given property", (Throwable)modelRuntimeException);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(closableIterator);
                throw throwable;
            }
            ModelUtil.closeClosable(closableIterator);
            return null;
        }
        ModelUtil.closeClosable(closableIterator);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Node> getAllPropertyValues(Model model, Resource resource, URI uRI) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        ClosableIterator closableIterator = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                linkedList.add(statement.getObject());
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            try {
                log.warn("Couldn't get all property values", (Throwable)modelRuntimeException);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(closableIterator);
                throw throwable;
            }
            ModelUtil.closeClosable(closableIterator);
        }
        ModelUtil.closeClosable(closableIterator);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllPropertyValues(Model model, Resource resource, URI uRI) {
        ClosableIterator closableIterator = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                linkedList.add(statement);
            }
            closableIterator.close();
            for (Statement statement : linkedList) {
                model.removeStatement(statement);
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            try {
                log.warn("Couldn't remove all property values", (Throwable)modelRuntimeException);
            }
            catch (Throwable throwable) {
                ModelUtil.closeClosable(closableIterator);
                throw throwable;
            }
            ModelUtil.closeClosable(closableIterator);
        }
        ModelUtil.closeClosable(closableIterator);
    }

    private static void closeClosable(ClosableIterator closableIterator) {
        if (closableIterator != null) {
            closableIterator.close();
        }
    }

    public static Object convertNode(Node node, Class<?> clazz) {
        try {
            if (clazz.equals(String.class)) {
                return node.toString();
            }
            if (clazz.equals(Node.class)) {
                return node;
            }
            if (clazz.equals(Resource.class)) {
                return node;
            }
            if (clazz.equals(URI.class)) {
                return node;
            }
            if (clazz.equals(Literal.class)) {
                return node;
            }
            if (clazz.equals(Integer.class)) {
                return new Integer(node.toString());
            }
            if (clazz.equals(Long.class)) {
                return new Long(node.toString());
            }
            if (clazz.equals(Boolean.class)) {
                String string = node.toString();
                if (string.equals("1")) {
                    return Boolean.TRUE;
                }
                if (string.equals("0")) {
                    return Boolean.FALSE;
                }
                return new Boolean(node.toString());
            }
            if (clazz.equals(Byte.class)) {
                return new Byte(node.toString());
            }
            if (clazz.equals(Short.class)) {
                return new Short(node.toString());
            }
            if (clazz.equals(Float.class)) {
                return new Float(node.toString());
            }
            if (clazz.equals(Double.class)) {
                return new Double(node.toString());
            }
            log.warn("Unknown class to convert node: " + node + ", clazz: " + clazz.getName());
            return null;
        }
        catch (Exception exception) {
            log.debug("Conversion failed. node: " + node + ", clazz: " + clazz.getName());
            return null;
        }
    }
}

