/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn.mgnt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.modeshape.connector.scm.ScmAction;
import org.modeshape.connector.svn.mgnt.ISVNEditorUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class UpdateFile
implements ScmAction {
    private String path;
    private String file;
    private byte[] oldData;
    private byte[] newData;

    public UpdateFile(String path, String file, byte[] oldData, byte[] newData) {
        this.path = path;
        this.file = file;
        this.oldData = oldData;
        this.newData = newData;
    }

    @Override
    public void applyAction(Object context) throws Exception {
        ISVNEditor editor = (ISVNEditor)context;
        ISVNEditorUtil.openDirectories(editor, this.path);
        editor.openFile(this.path + "/" + this.file, -1L);
        editor.applyTextDelta(this.path + "/" + this.file, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(this.path + "/" + this.file, (InputStream)new ByteArrayInputStream(this.oldData), 0L, (InputStream)new ByteArrayInputStream(this.newData), (ISVNDeltaConsumer)editor, true);
        editor.closeFile(this.path + "/" + this.file, checksum);
        ISVNEditorUtil.closeDirectories(editor, this.path);
    }

    public String toString() {
        return "UpdateFile {" + this.path + "/" + this.file + "}";
    }
}

