/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.addressbook.apple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.addressbook.AddressbookCrawler;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.FileUtil;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppleAddressbookCrawler
extends AddressbookCrawler {
    public static final String TYPE = "macosxaddressbook";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public AppleAddressbookCrawler() {
    }

    public AppleAddressbookCrawler(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataObject> crawlAddressbook() throws Exception {
        String string;
        Method method;
        Object obj;
        Object object;
        try {
            object = this.getClass().getClassLoader().loadClass("org.gnowsis.util.AppleUtils");
            obj = ((Class)object).newInstance();
            method = ((Class)object).getMethod("applescript", String.class);
        }
        catch (Exception exception) {
            throw new Exception("Could not load AppleUtils library.", exception);
        }
        try {
            object = this.getScript();
        }
        catch (IOException iOException) {
            throw new Exception("Could not read applescript resource", iOException);
        }
        try {
            string = (String)method.invoke(obj, object);
        }
        catch (Exception exception) {
            throw new Exception("Could not execute applescript!", exception);
        }
        Model model = null;
        Vector<DataObject> vector = new Vector<DataObject>();
        ClosableIterator closableIterator = null;
        try {
            model = this.createSimpleModel();
            model.readFrom((Reader)new StringReader(string), Syntax.RdfXml);
            closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDF.type, (NodeOrVariable)NCO.Contact);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                URIImpl uRIImpl = new URIImpl(statement.getSubject().toString(), false);
                RDFContainer rDFContainer = this.getRDFContainerFactory(uRIImpl.toString()).getRDFContainer((URI)uRIImpl);
                List<Statement> list = ModelUtil.getCBD(statement.getSubject(), model, true);
                rDFContainer.getModel().addAll(list.iterator());
                rDFContainer.add(NIE.rootElementOf, (Node)this.getDataSource().getID());
                vector.add(new DataObjectBase((URI)uRIImpl, this.source, rDFContainer));
            }
        }
        catch (ModelException modelException) {
            this.logger.error("Exception while crawling the apple addressbook", (Throwable)modelException);
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
            if (model != null) {
                model.close();
            }
        }
        return vector;
    }

    private String getScript() throws IOException {
        return FileUtil.readStreamAsUTF8(this.getClass().getResourceAsStream("addressbook.applescript"));
    }

    private Model createSimpleModel() {
        try {
            return RDF2Go.getModelFactory().createModel();
        }
        catch (Exception exception) {
            this.logger.error("Could not create a simple model", (Throwable)exception);
            return null;
        }
    }

    @Override
    public URI getContactListUri() {
        return new URIImpl("semdesk:macosxaddressbook");
    }
}

