/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.opendocument;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.opendocument.OpenDocumentExtractor;

public class OpenDocumentExtractorFactory
implements ExtractorFactory {
    private static final Set MIME_TYPES;

    private static void add(String string, Set set) {
        set.add("application/" + string);
        set.add("application/" + string + "-template");
        set.add("application/x-" + string);
        set.add("application/x-" + string + "-template");
    }

    public Extractor get() {
        return new OpenDocumentExtractor();
    }

    public Set getSupportedMimeTypes() {
        return MIME_TYPES;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.text", hashSet);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.spreadsheet", hashSet);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.graphics", hashSet);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.presentation", hashSet);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.image", hashSet);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.formula", hashSet);
        OpenDocumentExtractorFactory.add("vnd.oasis.opendocument.chart", hashSet);
        hashSet.add("application/vnd.oasis.opendocument.text-master");
        hashSet.add("application/vnd.oasis.opendocument.text-web");
        hashSet.add("application/x-vnd.oasis.opendocument.text-master");
        hashSet.add("application/x-vnd.oasis.opendocument.text-web");
        hashSet.add("application/vnd.sun.xml.writer");
        hashSet.add("application/vnd.sun.xml.writer.template");
        hashSet.add("application/vnd.sun.xml.writer.global");
        hashSet.add("application/vnd.sun.xml.calc");
        hashSet.add("application/vnd.sun.xml.calc.template");
        hashSet.add("application/vnd.sun.xml.draw");
        hashSet.add("application/vnd.sun.xml.draw.template");
        hashSet.add("application/vnd.sun.xml.impress");
        hashSet.add("application/vnd.sun.xml.impress.template");
        hashSet.add("application/vnd.sun.xml.math");
        hashSet.add("application/x-soffice");
        MIME_TYPES = Collections.unmodifiableSet(hashSet);
    }
}

