/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.PathWorkspace;
import org.modeshape.graph.connector.path.WritablePathWorkspace;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.request.CreateWorkspaceRequest;

@ThreadSafe
public abstract class WritablePathRepository
extends PathRepository {
    public WritablePathRepository(PathRepositorySource source) {
        super(source);
    }

    protected abstract WritablePathWorkspace createWorkspace(ExecutionContext var1, String var2);

    public WritablePathWorkspace createWorkspace(ExecutionContext context, String name, CreateWorkspaceRequest.CreateConflictBehavior behavior) {
        String newName = name;
        boolean conflictingName = this.workspaces.containsKey(newName);
        if (conflictingName) {
            switch (behavior) {
                case DO_NOT_CREATE: {
                    return null;
                }
                case CREATE_WITH_ADJUSTED_NAME: {
                    int counter = 0;
                    while (this.workspaces.containsKey(newName = name + ++counter)) {
                    }
                    break;
                }
            }
        }
        assert (!this.workspaces.containsKey(newName));
        WritablePathWorkspace workspace = this.createWorkspace(context, name);
        this.workspaces.put(name, workspace);
        return workspace;
    }

    public WritablePathWorkspace createWorkspace(ExecutionContext context, String name, CreateWorkspaceRequest.CreateConflictBehavior existingWorkspaceBehavior, String nameOfWorkspaceToClone) {
        WritablePathWorkspace workspace = this.createWorkspace(context, name, existingWorkspaceBehavior);
        if (workspace == null) {
            return null;
        }
        PathWorkspace original = this.getWorkspace(nameOfWorkspaceToClone);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path rootPath = pathFactory.createRootPath();
        if (original != null) {
            PathNode root = workspace.getNode(rootPath);
            PathNode origRoot = original.getNode(rootPath);
            workspace.removeProperties(context, rootPath, root.getProperties().keySet());
            workspace.setProperties(context, rootPath, origRoot.getProperties());
            for (Path.Segment childSegment : origRoot.getChildSegments()) {
                Path childPath = pathFactory.create(origRoot.getPath(), childSegment);
                PathNode originalNode = original.getNode(childPath);
                workspace.copyNode(context, originalNode, original, root, childSegment.getName(), true);
            }
        }
        this.workspaces.put(name, workspace);
        return workspace;
    }

    public boolean destroyWorkspace(String name) {
        return this.workspaces.remove(name) != null;
    }

    public boolean isWritable() {
        return true;
    }
}

