/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.connector.infinispan.BaseInfinispanSource;
import org.modeshape.connector.infinispan.InfinispanNode;
import org.modeshape.connector.infinispan.InfinispanTransaction;
import org.modeshape.connector.infinispan.InfinispanWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Repository;

@ThreadSafe
public class InfinispanRepository
extends Repository<InfinispanNode, InfinispanWorkspace> {
    private final CacheContainer cacheContainer;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<String> predefinedWorkspaceNames;

    public InfinispanRepository(BaseInfinispanSource source, CacheContainer cacheContainer) {
        super((BaseRepositorySource)source);
        this.cacheContainer = source.createCacheContainer();
        assert (this.cacheContainer != null);
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : source.getPredefinedWorkspaceNames()) {
            workspaceNames.add(workspaceName);
        }
        this.predefinedWorkspaceNames = Collections.unmodifiableSet(workspaceNames);
        this.initialize();
    }

    public Set<String> getWorkspaceNames() {
        HashSet<String> names = new HashSet<String>(super.getWorkspaceNames());
        names.addAll(this.predefinedWorkspaceNames);
        names.addAll(this.getAllWorkspaceNames(names));
        return Collections.unmodifiableSet(names);
    }

    protected Set<String> getAllWorkspaceNames(Set<String> alreadyKnownNames) {
        Set<String> cacheNames = null;
        cacheNames = this.cacheContainer instanceof EmbeddedCacheManager ? new HashSet<String>(((EmbeddedCacheManager)this.cacheContainer).getCacheNames()) : (this.cacheContainer instanceof RemoteCacheManager ? alreadyKnownNames : alreadyKnownNames);
        if (((Object)cacheNames).equals(alreadyKnownNames)) {
            return cacheNames;
        }
        UUID rootNodeUuid = this.getRootNodeUuid();
        HashSet<String> nonWorkspaceCacheNames = new HashSet<String>();
        for (String cacheName : cacheNames) {
            Cache cache;
            if (alreadyKnownNames.contains(cacheName) || (cache = this.cacheContainer.getCache(cacheName)).containsKey((Object)rootNodeUuid)) continue;
            nonWorkspaceCacheNames.add(cacheName);
        }
        if (!nonWorkspaceCacheNames.isEmpty()) {
            cacheNames.removeAll(nonWorkspaceCacheNames);
        }
        return cacheNames;
    }

    protected Cache<UUID, InfinispanNode> getCacheOrCreateIfMissing(String cacheName) {
        if (this.cacheContainer instanceof EmbeddedCacheManager) {
            EmbeddedCacheManager mgr = (EmbeddedCacheManager)this.cacheContainer;
            if (mgr.isRunning(cacheName)) {
                return mgr.getCache(cacheName);
            }
            if (mgr.getCacheNames().contains(cacheName)) {
                Cache cache = mgr.getCache(cacheName);
                cache.start();
                return cache;
            }
            mgr.defineConfiguration(cacheName, mgr.getDefaultConfiguration());
            return mgr.getCache(cacheName);
        }
        return this.cacheContainer.getCache(cacheName);
    }

    protected CacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public void shutdown() {
        this.cacheContainer.stop();
    }

    public InfinispanTransaction startTransaction(ExecutionContext context, boolean readonly) {
        Lock lock = readonly ? this.lock.readLock() : this.lock.writeLock();
        lock.lock();
        return new InfinispanTransaction(context, this, this.getRootNodeUuid(), lock);
    }
}

