/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.locking;

import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.webdav.ITransaction;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.locking.IResourceLocks;
import net.sf.webdav.locking.LockedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLocks
implements IResourceLocks {
    private static Logger LOG = LoggerFactory.getLogger(ResourceLocks.class);
    private final int _cleanupLimit = 100000;
    protected int _cleanupCounter = 0;
    protected Hashtable<String, LockedObject> _locks = new Hashtable();
    protected Hashtable<String, LockedObject> _locksByID = new Hashtable();
    protected Hashtable<String, LockedObject> _tempLocks = new Hashtable();
    protected Hashtable<String, LockedObject> _tempLocksByID = new Hashtable();
    protected LockedObject _root = new LockedObject(this, "/", true);
    protected LockedObject _tempRoot = new LockedObject(this, "/", false);
    private boolean _temporary = true;

    public synchronized boolean lock(ITransaction transaction, String path, String owner, boolean exclusive, int depth, int timeout, boolean temporary) throws LockFailedException {
        LockedObject lo = null;
        if (temporary) {
            lo = this.generateTempLockedObjects(transaction, path);
            lo._type = "read";
        } else {
            lo = this.generateLockedObjects(transaction, path);
            lo._type = "write";
        }
        if (lo.checkLocks(exclusive, depth)) {
            lo._exclusive = exclusive;
            lo._lockDepth = depth;
            lo._expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
            if (lo._parent != null) {
                lo._parent._expiresAt = lo._expiresAt;
                if (lo._parent.equals(this._root)) {
                    LockedObject rootLo = this.getLockedObjectByPath(transaction, this._root.getPath());
                    rootLo._expiresAt = lo._expiresAt;
                } else if (lo._parent.equals(this._tempRoot)) {
                    LockedObject tempRootLo = this.getTempLockedObjectByPath(transaction, this._tempRoot.getPath());
                    tempRootLo._expiresAt = lo._expiresAt;
                }
            }
            if (lo.addLockedObjectOwner(owner)) {
                return true;
            }
            LOG.trace("Couldn't set owner \"" + owner + "\" to resource at '" + path + "'");
            return false;
        }
        LOG.trace("Lock resource at " + path + " failed because" + "\na parent or child resource is currently locked");
        return false;
    }

    public synchronized boolean unlock(ITransaction transaction, String id, String owner) {
        if (this._locksByID.containsKey(id)) {
            String path = this._locksByID.get(id).getPath();
            if (this._locks.containsKey(path)) {
                LockedObject lo = this._locks.get(path);
                lo.removeLockedObjectOwner(owner);
                if (lo._children == null && lo._owner == null) {
                    lo.removeLockedObject();
                }
            } else {
                LOG.trace("net.sf.webdav.locking.ResourceLocks.unlock(): no lock for path " + path);
                return false;
            }
            if (this._cleanupCounter > 100000) {
                this._cleanupCounter = 0;
                this.cleanLockedObjects(transaction, this._root, !this._temporary);
            }
        }
        this.checkTimeouts(transaction, !this._temporary);
        return true;
    }

    public synchronized void unlockTemporaryLockedObjects(ITransaction transaction, String path, String owner) {
        if (this._tempLocks.containsKey(path)) {
            LockedObject lo = this._tempLocks.get(path);
            lo.removeLockedObjectOwner(owner);
        } else {
            LOG.trace("net.sf.webdav.locking.ResourceLocks.unlock(): no lock for path " + path);
        }
        if (this._cleanupCounter > 100000) {
            this._cleanupCounter = 0;
            this.cleanLockedObjects(transaction, this._tempRoot, this._temporary);
        }
        this.checkTimeouts(transaction, this._temporary);
    }

    public void checkTimeouts(ITransaction transaction, boolean temporary) {
        if (!temporary) {
            Enumeration<LockedObject> lockedObjects = this._locks.elements();
            while (lockedObjects.hasMoreElements()) {
                LockedObject currentLockedObject = lockedObjects.nextElement();
                if (currentLockedObject._expiresAt >= System.currentTimeMillis()) continue;
                currentLockedObject.removeLockedObject();
            }
        } else {
            Enumeration<LockedObject> lockedObjects = this._tempLocks.elements();
            while (lockedObjects.hasMoreElements()) {
                LockedObject currentLockedObject = lockedObjects.nextElement();
                if (currentLockedObject._expiresAt >= System.currentTimeMillis()) continue;
                currentLockedObject.removeTempLockedObject();
            }
        }
    }

    public boolean exclusiveLock(ITransaction transaction, String path, String owner, int depth, int timeout) throws LockFailedException {
        return this.lock(transaction, path, owner, true, depth, timeout, false);
    }

    public boolean sharedLock(ITransaction transaction, String path, String owner, int depth, int timeout) throws LockFailedException {
        return this.lock(transaction, path, owner, false, depth, timeout, false);
    }

    public LockedObject getLockedObjectByID(ITransaction transaction, String id) {
        if (this._locksByID.containsKey(id)) {
            return this._locksByID.get(id);
        }
        return null;
    }

    public LockedObject getLockedObjectByPath(ITransaction transaction, String path) {
        if (this._locks.containsKey(path)) {
            return this._locks.get(path);
        }
        return null;
    }

    public LockedObject getTempLockedObjectByID(ITransaction transaction, String id) {
        if (this._tempLocksByID.containsKey(id)) {
            return this._tempLocksByID.get(id);
        }
        return null;
    }

    public LockedObject getTempLockedObjectByPath(ITransaction transaction, String path) {
        if (this._tempLocks.containsKey(path)) {
            return this._tempLocks.get(path);
        }
        return null;
    }

    private LockedObject generateLockedObjects(ITransaction transaction, String path) {
        if (!this._locks.containsKey(path)) {
            LockedObject returnObject = new LockedObject(this, path, !this._temporary);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                LockedObject parentLockedObject = this.generateLockedObjects(transaction, parentPath);
                parentLockedObject.addChild(returnObject);
                returnObject._parent = parentLockedObject;
            }
            return returnObject;
        }
        return this._locks.get(path);
    }

    private LockedObject generateTempLockedObjects(ITransaction transaction, String path) {
        if (!this._tempLocks.containsKey(path)) {
            LockedObject returnObject = new LockedObject(this, path, this._temporary);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                LockedObject parentLockedObject = this.generateTempLockedObjects(transaction, parentPath);
                parentLockedObject.addChild(returnObject);
                returnObject._parent = parentLockedObject;
            }
            return returnObject;
        }
        return this._tempLocks.get(path);
    }

    private boolean cleanLockedObjects(ITransaction transaction, LockedObject lo, boolean temporary) {
        if (lo._children == null) {
            if (lo._owner == null) {
                if (temporary) {
                    lo.removeTempLockedObject();
                } else {
                    lo.removeLockedObject();
                }
                return true;
            }
            return false;
        }
        boolean canDelete = true;
        int limit = lo._children.length;
        for (int i = 0; i < limit; ++i) {
            if (!this.cleanLockedObjects(transaction, lo._children[i], temporary)) {
                canDelete = false;
                continue;
            }
            --i;
            --limit;
        }
        if (canDelete) {
            if (lo._owner == null) {
                if (temporary) {
                    lo.removeTempLockedObject();
                } else {
                    lo.removeLockedObject();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return null;
        }
        if (slash == 0) {
            return "/";
        }
        return path.substring(0, slash);
    }
}

