/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IMimeTyper;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.DeterminableMethod;
import net.sf.webdav.methods.DoHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoGet
extends DoHead {
    private static Logger LOG = LoggerFactory.getLogger(DoGet.class);

    public DoGet(IWebdavStore store, String dftIndexFile, String insteadOf404, ResourceLocks resourceLocks, IMimeTyper mimeTyper, int contentLengthHeader) {
        super(store, dftIndexFile, insteadOf404, resourceLocks, mimeTyper, contentLengthHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBody(ITransaction transaction, HttpServletResponse resp, String path) {
        try {
            StoredObject so = this._store.getStoredObject(transaction, path);
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            ServletOutputStream out = resp.getOutputStream();
            InputStream in = this._store.getResourceContent(transaction, path);
            try {
                int read = -1;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    out.write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOG.warn("Closing InputStream causes Exception!\n" + e.toString());
                }
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    LOG.warn("Flushing OutputStream causes Exception!\n" + e.toString());
                }
            }
        }
        catch (Exception e) {
            LOG.trace(e.toString());
        }
    }

    protected void folderBody(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
        StoredObject so = this._store.getStoredObject(transaction, path);
        if (so == null) {
            resp.sendError(404, req.getRequestURI());
        } else {
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            if (so.isFolder()) {
                ServletOutputStream out = resp.getOutputStream();
                String[] children = this._store.getChildrenNames(transaction, path);
                children = children == null ? new String[]{} : children;
                StringBuffer childrenTemp = new StringBuffer();
                childrenTemp.append("Contents of this Folder:\n");
                for (String child : children) {
                    childrenTemp.append(child);
                    childrenTemp.append("\n");
                }
                out.write(childrenTemp.toString().getBytes());
            }
        }
    }
}

