/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class HttpClientUtil {
    public static void formUrlEncode(String string, StringBuilder stringBuilder) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuilder.append('+');
                continue;
            }
            char c2 = c;
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('%');
            String string2 = Integer.toHexString(c);
            if (string2.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
    }

    public static String formUrlEncode(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        HttpClientUtil.formUrlEncode(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void setAcceptGZIPEncoding(URLConnection uRLConnection) {
        uRLConnection.setRequestProperty("Accept-Encoding", "gzip");
    }

    public static InputStream getInputStream(URLConnection uRLConnection) throws IOException {
        InputStream inputStream = uRLConnection.getInputStream();
        if ("gzip".equalsIgnoreCase(uRLConnection.getContentEncoding())) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }
}

