/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mbox;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import net.fortuna.mstor.util.CapabilityHints;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.mail.AbstractJavaMailCrawler;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.mbox.MboxDataSource;
import org.semanticdesktop.aperture.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MboxCrawler
extends AbstractJavaMailCrawler {
    private static final String MBOX_URL_SCHEME = "mbox:";
    private static final String MSTOR_PROVIDER_PATH_PREFX = "mstor:";
    private static final String SIZE_KEY = "size";
    private static final String SUBFOLDERS_KEY = "subfolders";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MboxDataSource configuredDataSource;
    private Store store;
    private String mboxStoreUri;

    protected ExitCode crawlObjects() {
        this.retrieveConfigurationData(this.getDataSource());
        try {
            this.ensureConnectedStore();
        }
        catch (MessagingException messagingException) {
            this.logger.warn("Unable to open and MBOX file", (Throwable)messagingException);
            this.closeConnection();
            return ExitCode.FATAL_ERROR;
        }
        boolean bl = false;
        try {
            int n = this.baseFolders.size();
            if (n == 0) {
                Folder folder = this.store.getDefaultFolder();
                folder.open(1);
                this.crawlFolder(this.store.getDefaultFolder(), 0);
            } else {
                for (int i = 0; i < n; ++i) {
                    String string = (String)this.baseFolders.get(i);
                    Folder folder = this.store.getFolder(string);
                    this.crawlFolder(folder, 0);
                }
            }
        }
        catch (MessagingException messagingException) {
            this.logger.warn("MessagingException while crawling", (Throwable)messagingException);
            bl = true;
        }
        this.closeConnection();
        if (bl) {
            return ExitCode.FATAL_ERROR;
        }
        if (this.isStopRequested()) {
            return ExitCode.STOP_REQUESTED;
        }
        return ExitCode.COMPLETED;
    }

    private void retrieveConfigurationData(DataSource dataSource) {
        if (dataSource == this.configuredDataSource) {
            return;
        }
        this.configuredDataSource = (MboxDataSource)dataSource;
        this.baseFolders.clear();
        String string = this.configuredDataSource.getMboxPath();
        this.mboxStoreUri = string == null ? null : MSTOR_PROVIDER_PATH_PREFX + string.replace('\\', '/');
        Integer n = this.configuredDataSource.getMaximumDepth();
        this.maxDepth = n == null ? -1 : n;
        Long l = this.configuredDataSource.getMaximumSize();
        this.maximumByteSize = l == null ? Long.MAX_VALUE : l;
        if (this.store != null) {
            this.closeConnection();
            this.store = null;
        }
    }

    private void ensureConnectedStore() throws MessagingException {
        if (this.store == null) {
            CapabilityHints.setHint((String)"mstor.metadata", (String)"disabled");
            CapabilityHints.setHint((String)"mstor.mbox.cacheBuffers", (String)"disabled");
            CapabilityHints.setHint((String)"mstor.mbox.bufferStrategy", (String)"default");
            System.setProperty("mstor.cache.maxentries", "1");
            Session session = Session.getDefaultInstance((Properties)new Properties());
            this.store = session.getStore(new URLName(this.mboxStoreUri));
        }
        if (!this.store.isConnected()) {
            this.store.connect();
        }
    }

    private void closeConnection() {
        if (this.store != null && this.store.isConnected()) {
            try {
                this.store.close();
            }
            catch (MessagingException messagingException) {
                this.logger.warn("Unable to close connection", (Throwable)messagingException);
            }
        }
    }

    protected void recordCurrentFolderInAccessData(AccessData accessData) throws MessagingException {
        if (accessData != null) {
            if (MboxCrawler.holdsMessages(this.currentFolder)) {
                int n = this.currentFolder.getMessageCount() - this.currentFolder.getDeletedMessageCount();
                accessData.put(this.currentFolderURI.toString(), SIZE_KEY, String.valueOf(n));
            }
            if (MboxCrawler.holdsFolders(this.currentFolder)) {
                accessData.put(this.currentFolderURI.toString(), SUBFOLDERS_KEY, this.getSubFoldersString(this.currentFolder));
            }
        }
    }

    protected boolean checkIfCurrentFolderHasBeenChanged(AccessData accessData) throws MessagingException {
        return this.currentFolder.isOpen();
    }

    private String getFolderURIPrefix(Folder folder) throws MessagingException {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(MBOX_URL_SCHEME);
        stringBuilder.append('/');
        stringBuilder.append(this.encodeFolderPath(folder.getFullName()));
        return stringBuilder.toString();
    }

    private String encodeFolderPath(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuilder.append('+');
                continue;
            }
            char c2 = c;
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '/' || c2 == ':' || c2 == '.' || c2 == '-') {
                stringBuilder.append(c);
                continue;
            }
            if (c2 == '\\') {
                stringBuilder.append('/');
                continue;
            }
            stringBuilder.append('%');
            String string2 = Integer.toHexString(c);
            if (string2.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    protected URI getFolderURI(Folder folder) throws MessagingException {
        return new URIImpl(this.getFolderURIPrefix(folder));
    }

    protected String getMessageUri(Folder folder, Message message) throws MessagingException {
        String[] stringArray = message.getHeader("Message-ID");
        String string = null;
        String string2 = null;
        try {
            string2 = IOUtil.rollingHash(message.getInputStream());
        }
        catch (IOException iOException) {
            throw new MessagingException("Couldn't obtain a hash of the message");
        }
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
            if (string.startsWith("<")) {
                string = string.substring(1);
            }
            if (string.endsWith(">")) {
                string = string.substring(0, string.length() - 1);
            }
            try {
                string = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration enumeration = message.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                stringBuilder.append(header.getName());
                stringBuilder.append(header.getValue());
            }
            string = String.valueOf(stringBuilder.toString().hashCode());
        }
        return this.getFolderURIPrefix(folder) + "/" + string + "-" + string2;
    }
}

