/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.plaintext;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.util.UtfUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextExtractor
implements Extractor {
    private static final int STRING_TEST_LENGTH = 256;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            Object object;
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
            byte[] byArray = IOUtil.readBytes(pushbackInputStream, 4);
            byte[] byArray2 = UtfUtil.findMatchingBOM(byArray);
            if (byArray2 == null) {
                pushbackInputStream.unread(byArray);
            } else {
                pushbackInputStream.unread(byArray, byArray2.length, byArray.length - byArray2.length);
                object = UtfUtil.getCharsetName(byArray2);
                if (object != null) {
                    try {
                        charset = Charset.forName((String)object);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        this.logger.info("Unsupported charset, trying to continue with current charset", (Throwable)unsupportedCharsetException);
                    }
                }
            }
            object = charset == null ? new InputStreamReader(pushbackInputStream) : new InputStreamReader((InputStream)pushbackInputStream, charset);
            PushbackReader pushbackReader = new PushbackReader((Reader)object, 256);
            String string2 = IOUtil.readString(pushbackReader, 256);
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (Character.isDefined(c) && (!Character.isISOControl(c) || Character.isWhitespace(c))) continue;
                this.logger.warn("Document does not contain plain text");
                return;
            }
            pushbackReader.unread(string2.toCharArray());
            String string3 = IOUtil.readString(pushbackReader);
            if (string3.length() > 0) {
                rDFContainer.add(RDF.type, (Node)NFO.PlainTextDocument);
                rDFContainer.add(NIE.plainTextContent, string3);
            }
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }
}

