/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.infinispan.BaseInfinispanSource;
import org.modeshape.connector.infinispan.InfinispanConnectorI18n;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositorySourceException;

@ThreadSafe
public class InfinispanSource
extends BaseInfinispanSource {
    private static final long serialVersionUID = 2L;
    protected static final String CACHE_CONFIGURATION_NAME = "cacheConfigurationName";
    protected static final String CACHE_FACTORY_JNDI_NAME = "cacheContainerJndiName";
    @Description(i18n=InfinispanConnectorI18n.class, value="cacheConfigurationNamePropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="cacheConfigurationNamePropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="cacheConfigurationNamePropertyCategory")
    private volatile String cacheConfigurationName;
    @Description(i18n=InfinispanConnectorI18n.class, value="cacheContainerJndiNamePropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="cacheContainerJndiNamePropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="cacheContainerJndiNamePropertyCategory")
    private volatile String cacheContainerJndiName;

    public String getCacheContainerJndiName() {
        return this.cacheContainerJndiName;
    }

    public synchronized void setCacheContainerJndiName(String jndiName) {
        if (this.cacheContainerJndiName == jndiName || this.cacheContainerJndiName != null && this.cacheContainerJndiName.equals(jndiName)) {
            return;
        }
        this.cacheContainerJndiName = jndiName;
    }

    @Deprecated
    public String getCacheManagerJndiName() {
        return this.getCacheContainerJndiName();
    }

    @Deprecated
    public synchronized void setCacheManagerJndiName(String jndiName) {
        this.setCacheContainerJndiName(jndiName);
    }

    public String getCacheConfigurationName() {
        return this.cacheConfigurationName;
    }

    public synchronized void setCacheConfigurationName(String cacheConfigurationName) {
        if (this.cacheConfigurationName == cacheConfigurationName || this.cacheConfigurationName != null && this.cacheConfigurationName.equals(cacheConfigurationName)) {
            return;
        }
        this.cacheConfigurationName = cacheConfigurationName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CacheContainer createCacheContainer() {
        DefaultCacheManager cacheContainer = null;
        String jndiName = this.getCacheContainerJndiName();
        if (jndiName != null && jndiName.trim().length() != 0) {
            Object object = null;
            try {
                Context context = super.getContext();
                if (context == null) {
                    try {
                        context = new InitialContext();
                    }
                    catch (NamingException err) {
                        throw new RepositorySourceException(this.getName(), (Throwable)err);
                    }
                }
                if ((object = context.lookup(jndiName)) == null) return cacheContainer;
                return (CacheContainer)object;
            }
            catch (ClassCastException err) {
                I18n msg = InfinispanConnectorI18n.objectFoundInJndiWasNotCacheContainer;
                String className = object != null ? object.getClass().getName() : "null";
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{jndiName, this.getName(), className}), (Throwable)err);
            }
            catch (Throwable err) {
                if (!(err instanceof RuntimeException)) throw new RepositorySourceException(this.getName(), err);
                throw (RuntimeException)err;
            }
        }
        String configName = this.getCacheConfigurationName();
        if (configName == null) {
            return new DefaultCacheManager();
        }
        InputStream configStream = this.getClass().getResourceAsStream(configName);
        try {
            if (configStream == null) {
                configStream = new FileInputStream(configName);
            }
        }
        catch (IOException ioe) {
            I18n msg = InfinispanConnectorI18n.configFileNotFound;
            throw new RepositorySourceException(super.getName(), msg.text(new Object[]{configName}), (Throwable)ioe);
        }
        try {
            cacheContainer = new DefaultCacheManager(configStream);
            return cacheContainer;
        }
        catch (IOException ioe) {
            I18n msg = InfinispanConnectorI18n.configFileNotValid;
            throw new RepositorySourceException(super.getName(), msg.text(new Object[]{configName}), (Throwable)ioe);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException ioe) {}
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InfinispanSource) {
            InfinispanSource that = (InfinispanSource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.getName()});
    }

    @Override
    public synchronized Reference getReference() {
        Reference ref = super.getReference();
        ref.add(new StringRefAddr(CACHE_FACTORY_JNDI_NAME, this.getCacheContainerJndiName()));
        ref.add(new StringRefAddr(CACHE_CONFIGURATION_NAME, this.getCacheConfigurationName()));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get("sourceName");
            String rootNodeUuidString = (String)values.get("rootNodeUuid");
            String cacheContainerJndiName = (String)values.get(CACHE_FACTORY_JNDI_NAME);
            String cacheConfigurationName = (String)values.get(CACHE_CONFIGURATION_NAME);
            Object defaultCachePolicy = values.get("defaultCachePolicy");
            String retryLimit = (String)values.get("retryLimit");
            String defaultWorkspace = (String)values.get("defaultWorkspace");
            String createWorkspaces = (String)values.get("allowCreatingWorkspaces");
            String updatesAllowed = (String)values.get("updatesAllowed");
            String combinedWorkspaceNames = (String)values.get("predefinedWorkspaceNames");
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            InfinispanSource source = new InfinispanSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(rootNodeUuidString);
            }
            if (cacheContainerJndiName != null) {
                source.setCacheContainerJndiName(cacheContainerJndiName);
            }
            if (cacheConfigurationName != null) {
                source.setCacheConfigurationName(cacheConfigurationName);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (updatesAllowed != null) {
                source.setUpdatesAllowed(Boolean.valueOf(updatesAllowed));
            }
            return source;
        }
        return null;
    }
}

