/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.modeshape.common.text.Inflector;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;

public class XmiGraphReader {
    protected static final Map<String, String> EDATATYPE_TO_JCR_TYPENAME;
    protected final ExecutionContext context;
    protected final ValueFactories valueFactories;
    protected final ValueFactory<String> stringFactory;
    protected final ValueFactory<Boolean> booleanFactory;
    protected final NameFactory nameFactory;
    protected final PathFactory pathFactory;
    protected final UuidFactory uuidFactory;
    protected final PropertyFactory propertyFactory;
    protected final Subgraph subgraph;
    protected final NamespaceRegistry namespaces;
    protected final Inflector inflector;
    protected final boolean generateShortNames;
    protected String currentNamespaceUri;
    protected final Map<Name, Name> typeNameReplacements = new HashMap<Name, Name>();

    protected XmiGraphReader(Subgraph subgraph, boolean generateShortNames) {
        this.subgraph = subgraph;
        this.context = subgraph.getGraph().getContext();
        this.valueFactories = subgraph.getGraph().getContext().getValueFactories();
        this.nameFactory = this.valueFactories.getNameFactory();
        this.stringFactory = this.valueFactories.getStringFactory();
        this.booleanFactory = this.valueFactories.getBooleanFactory();
        this.pathFactory = this.valueFactories.getPathFactory();
        this.uuidFactory = this.valueFactories.getUuidFactory();
        this.propertyFactory = this.context.getPropertyFactory();
        this.namespaces = this.context.getNamespaceRegistry();
        this.inflector = Inflector.getInstance();
        this.generateShortNames = generateShortNames;
    }

    protected void replaceTypeName(Name replaced, Name with) {
        this.typeNameReplacements.put(replaced, with);
    }

    protected void replaceTypeName(String replaced, String with) {
        this.replaceTypeName(this.nameFrom(replaced), this.nameFrom(with));
    }

    protected void setCurrentNamespaceUri(String uri) {
        this.currentNamespaceUri = uri;
    }

    public String getCurrentNamespaceUri() {
        return this.currentNamespaceUri;
    }

    protected String namespacePrefix(String prefix) {
        return this.inflector.lowerCamelCase(prefix, new char[0]);
    }

    protected String firstValue(Node node, Name propertyName) {
        return this.firstValue(node, propertyName, null);
    }

    protected String firstValue(Node node, Name propertyName, String defaultValue) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return defaultValue;
        }
        return (String)this.stringFactory.create(property.getFirstValue());
    }

    protected String firstValue(Node node, String propertyName) {
        return this.firstValue(node, propertyName, null);
    }

    protected String firstValue(Node node, String propertyName, String defaultValue) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return defaultValue;
        }
        return (String)this.stringFactory.create(property.getFirstValue());
    }

    protected boolean firstValue(Node node, String propertyName, boolean defaultValue) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return defaultValue;
        }
        return (Boolean)this.booleanFactory.create(property.getFirstValue());
    }

    protected long firstValue(Node node, String propertyName, long defaultValue) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return defaultValue;
        }
        return (Long)this.valueFactories.getLongFactory().create(property.getFirstValue());
    }

    protected double firstValue(Node node, String propertyName, double defaultValue) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return defaultValue;
        }
        return (Double)this.valueFactories.getDoubleFactory().create(property.getFirstValue());
    }

    protected List<String> values(Node node, String propertyName, String regexDelimiter) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : property) {
            String stringValue = (String)this.stringFactory.create(value);
            for (String val : stringValue.split(regexDelimiter)) {
                if (val == null) continue;
                values.add(val);
            }
        }
        return values;
    }

    protected List<Name> names(Node node, String propertyName, String regexDelimiter) {
        Property property = node.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Name> values = new ArrayList<Name>();
        for (Object value : property) {
            String stringValue = (String)this.stringFactory.create(value);
            for (String val : stringValue.split(regexDelimiter)) {
                if (val == null) continue;
                values.add(this.nameFrom(val));
            }
        }
        return values;
    }

    protected String jcrTypeNameFor(Name dataType) {
        String localName;
        String result;
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(dataType.getNamespaceUri()) && (result = EDATATYPE_TO_JCR_TYPENAME.get(localName = dataType.getLocalName())) != null) {
            return result;
        }
        return "UNDEFINED";
    }

    protected Path pathFrom(Object path) {
        return (Path)this.pathFactory.create(path);
    }

    protected Path relativePathFrom(Name ... names) {
        return this.pathFactory.createRelativePath(names);
    }

    protected Path path(Path parent, Name name) {
        return this.path(parent, name, 1);
    }

    protected Path path(Path parent, String relativePath) {
        return this.pathFactory.create(parent, relativePath);
    }

    protected Path path(Path parent, Name name, int snsIndex) {
        return this.path(parent, this.pathFactory.createSegment(name, snsIndex));
    }

    protected Path path(Path parent, Path.Segment segment) {
        return this.pathFactory.create(parent, new Path.Segment[]{segment});
    }

    protected Property property(Name name, Object ... values) {
        return this.propertyFactory.create(name, values);
    }

    protected Property property(Name name, PropertyType type, Object ... values) {
        return this.propertyFactory.create(name, type, values);
    }

    protected Name nameFrom(String name) {
        String value = name;
        if (value.startsWith("#//")) {
            value = value.substring(3);
        } else if (value.startsWith("//")) {
            value = value.substring(2);
        }
        if (value.startsWith("ecore:EDataType ")) {
            value = value.substring("ecore:DataType ".length() + 1);
        }
        Name result = null;
        String[] parts = value.split("\\#");
        if (parts.length == 2) {
            String uri = parts[0].trim();
            String localName = this.nameFrom(parts[1]).getLocalName();
            result = this.shortenName(this.nameFactory.create(uri, localName));
        } else {
            value = this.inflector.underscore(value, new char[]{'_', '-', '.'});
            value = this.inflector.lowerCamelCase(value, new char[]{'_'});
            result = this.shortenName((Name)this.nameFactory.create(value));
        }
        return this.nameFrom(result);
    }

    protected Name nameFrom(Name name) {
        if (this.currentNamespaceUri != null && name.getNamespaceUri().isEmpty()) {
            name = this.nameFactory.create(this.currentNamespaceUri, name.getLocalName());
        }
        return name;
    }

    protected Name typeNameFrom(Name name) {
        Name replacement;
        String singularLocalName = this.inflector.singularize((Object)name.getLocalName());
        if (this.currentNamespaceUri != null && name.getNamespaceUri().isEmpty()) {
            name = this.nameFactory.create(this.currentNamespaceUri, singularLocalName);
        }
        if (!singularLocalName.equals(name.getLocalName())) {
            name = this.nameFactory.create(name.getNamespaceUri(), singularLocalName);
        }
        name = (replacement = this.typeNameReplacements.get(name)) != null ? replacement : name;
        return this.shortenName(name);
    }

    protected Name nameForHref(Name eObjectReferenceName) {
        String localPart = eObjectReferenceName.getLocalName();
        String singular = this.inflector.singularize((Object)localPart);
        String suffix = singular.equals(localPart) ? "Href" : "Hrefs";
        return this.nameFactory.create(eObjectReferenceName.getNamespaceUri(), singular + suffix);
    }

    protected Name nameForResolvedReference(Name eObjectReferenceName) {
        return eObjectReferenceName;
    }

    protected Name nameForResolvedName(Name eObjectReferenceName) {
        String localPart = eObjectReferenceName.getLocalName();
        String singular = this.inflector.singularize((Object)localPart);
        String suffix = singular.equals(localPart) ? "Name" : "Names";
        return this.nameFactory.create(eObjectReferenceName.getNamespaceUri(), singular + suffix);
    }

    protected Name nameForResolvedId(Name eObjectReferenceName) {
        String localPart = eObjectReferenceName.getLocalName();
        String singular = this.inflector.singularize((Object)localPart);
        String suffix = singular.equals(localPart) ? "XmiUuid" : "XmiUuids";
        return this.nameFactory.create(eObjectReferenceName.getNamespaceUri(), singular + suffix);
    }

    protected String stringFrom(Object value) {
        return (String)this.stringFactory.create(value);
    }

    protected Name shortenName(Name name) {
        if (this.generateShortNames) {
            String localName = name.getLocalName();
            String prefix = this.namespaces.getPrefixForNamespaceUri(name.getNamespaceUri(), false);
            if (prefix != null && localName.startsWith(prefix) && localName.length() > prefix.length()) {
                localName = localName.substring(prefix.length());
                localName = this.inflector.underscore(localName, new char[]{'_', '-', '.'});
                if ((localName = this.inflector.lowerCamelCase(localName, new char[]{'_'})).length() > 0) {
                    return this.nameFactory.create(name.getNamespaceUri(), localName);
                }
            }
        }
        return name;
    }

    protected UUID uuidFor(Node node) {
        Property property = node.getProperty(JcrLexicon.UUID);
        if (property == null || property.isEmpty()) {
            property = node.getProperty(ModeShapeLexicon.UUID);
        }
        assert (property != null);
        UUID result = (UUID)this.uuidFactory.create(property.getFirstValue());
        assert (result != null);
        return result;
    }

    protected UUID xmiUuidFor(Node node) {
        Property property = node.getProperty("xmi:uuid");
        if (property == null) {
            return null;
        }
        String mmuuid = (String)this.stringFactory.create(property.getFirstValue());
        if (mmuuid.startsWith("mmuuid:")) {
            mmuuid = mmuuid.substring(7);
        }
        UUID result = (UUID)this.uuidFactory.create(mmuuid);
        assert (result != null);
        return result;
    }

    protected List<UUID> references(Property property) {
        LinkedList<UUID> result = null;
        try {
            for (Object value : property) {
                if (value instanceof String) {
                    String str = (String)value;
                    if (str.startsWith("mmuuid/")) {
                        String[] references;
                        for (String reference : references = str.split("\\s")) {
                            UUID uuid = (UUID)this.uuidFactory.create(reference.substring(7));
                            if (result == null) {
                                if (property.isSingle() && references.length == 1) {
                                    return Collections.singletonList(uuid);
                                }
                                result = new LinkedList<UUID>();
                            }
                            result.add(uuid);
                        }
                        continue;
                    }
                    assert (result == null);
                    return null;
                }
                assert (result == null);
                return null;
            }
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
        return result;
    }

    static {
        HashMap<String, String> types = new HashMap<String, String>();
        types.put("eBoolean", "BOOLEAN");
        types.put("eShort", "LONG");
        types.put("eInt", "LONG");
        types.put("eLong", "LONG");
        types.put("eFloat", "DOUBLE");
        types.put("eDouble", "DOUBLE");
        types.put("eBigDecimal", "DECIMAL");
        types.put("eBigInteger", "DECIMAL");
        types.put("eDate", "DATE");
        types.put("eString", "STRING");
        types.put("eChar", "STRING");
        types.put("eByte", "BINARY");
        types.put("eByteArray", "BINARY");
        types.put("eObject", "UNDEFINED");
        types.put("eBooleanObject", "BOOLEAN");
        types.put("eShortObject", "LONG");
        types.put("eIntObject", "LONG");
        types.put("eLongObject", "LONG");
        types.put("eFloatObject", "DOUBLE");
        types.put("eDoubleObject", "DOUBLE");
        types.put("eCharObject", "STRING");
        types.put("eByteObject", "BINARY");
        EDATATYPE_TO_JCR_TYPENAME = Collections.unmodifiableMap(types);
    }
}

