/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.qom;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.ArithmeticOperator;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.jcr.api.query.qom.ArithmeticOperand;
import org.modeshape.jcr.api.query.qom.Between;
import org.modeshape.jcr.api.query.qom.Limit;
import org.modeshape.jcr.api.query.qom.NodeDepth;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.QueryCommand;
import org.modeshape.jcr.api.query.qom.QueryObjectModelFactory;
import org.modeshape.jcr.api.query.qom.SetCriteria;
import org.modeshape.jcr.api.query.qom.SetQuery;
import org.modeshape.jcr.api.query.qom.Subquery;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.qom.JcrAnd;
import org.modeshape.jcr.query.qom.JcrArithmeticOperand;
import org.modeshape.jcr.query.qom.JcrBetween;
import org.modeshape.jcr.query.qom.JcrBindVariableName;
import org.modeshape.jcr.query.qom.JcrChildNode;
import org.modeshape.jcr.query.qom.JcrChildNodeJoinCondition;
import org.modeshape.jcr.query.qom.JcrColumn;
import org.modeshape.jcr.query.qom.JcrComparison;
import org.modeshape.jcr.query.qom.JcrConstraint;
import org.modeshape.jcr.query.qom.JcrDescendantNode;
import org.modeshape.jcr.query.qom.JcrDescendantNodeJoinCondition;
import org.modeshape.jcr.query.qom.JcrDynamicOperand;
import org.modeshape.jcr.query.qom.JcrEquiJoinCondition;
import org.modeshape.jcr.query.qom.JcrFullTextSearch;
import org.modeshape.jcr.query.qom.JcrFullTextSearchScore;
import org.modeshape.jcr.query.qom.JcrJoin;
import org.modeshape.jcr.query.qom.JcrJoinCondition;
import org.modeshape.jcr.query.qom.JcrLength;
import org.modeshape.jcr.query.qom.JcrLimit;
import org.modeshape.jcr.query.qom.JcrLiteral;
import org.modeshape.jcr.query.qom.JcrLowerCase;
import org.modeshape.jcr.query.qom.JcrNamedSelector;
import org.modeshape.jcr.query.qom.JcrNodeDepth;
import org.modeshape.jcr.query.qom.JcrNodeLocalName;
import org.modeshape.jcr.query.qom.JcrNodeName;
import org.modeshape.jcr.query.qom.JcrNodePath;
import org.modeshape.jcr.query.qom.JcrNot;
import org.modeshape.jcr.query.qom.JcrOr;
import org.modeshape.jcr.query.qom.JcrOrdering;
import org.modeshape.jcr.query.qom.JcrPropertyExistence;
import org.modeshape.jcr.query.qom.JcrPropertyValue;
import org.modeshape.jcr.query.qom.JcrQueryCommand;
import org.modeshape.jcr.query.qom.JcrQueryObjectModel;
import org.modeshape.jcr.query.qom.JcrReferenceValue;
import org.modeshape.jcr.query.qom.JcrSameNode;
import org.modeshape.jcr.query.qom.JcrSameNodeJoinCondition;
import org.modeshape.jcr.query.qom.JcrSelectQuery;
import org.modeshape.jcr.query.qom.JcrSetCriteria;
import org.modeshape.jcr.query.qom.JcrSetQuery;
import org.modeshape.jcr.query.qom.JcrSource;
import org.modeshape.jcr.query.qom.JcrStaticOperand;
import org.modeshape.jcr.query.qom.JcrSubquery;
import org.modeshape.jcr.query.qom.JcrUpperCase;

public class JcrQueryObjectModelFactory
implements QueryObjectModelFactory {
    public static final String LANGUAGE = "JCR-JQOM";
    private final JcrQueryContext context;

    public JcrQueryObjectModelFactory(JcrQueryContext context) {
        this.context = context;
    }

    protected SelectorName selectorName(String name) {
        return new SelectorName(name);
    }

    public JcrQueryObjectModel createQuery(Source source, Constraint constraint, Ordering[] orderings, Column[] columns) {
        JcrSelectQuery query = this.select(source, constraint, orderings, columns, null, false);
        String statement = query.toString();
        PlanHints hints = new PlanHints();
        hints.showPlan = true;
        hints.validateColumnExistance = true;
        return new JcrQueryObjectModel(this.context, statement, LANGUAGE, query, hints, null);
    }

    public JcrSelectQuery select(Source source, Constraint constraint, Ordering[] orderings, Column[] columns, Limit limit, boolean distinct) {
        JcrSource jcrSource = (JcrSource)CheckArg.getInstanceOf((Object)source, JcrSource.class, (String)"source");
        JcrConstraint jcrConstraint = null;
        if (constraint != null) {
            jcrConstraint = (JcrConstraint)CheckArg.getInstanceOf((Object)constraint, JcrConstraint.class, (String)"constraint");
        }
        ArrayList<Object> jcrColumns = null;
        if (columns != null) {
            jcrColumns = new ArrayList<Object>();
            for (int i = 0; i != columns.length; ++i) {
                jcrColumns.add(CheckArg.getInstanceOf((Object)columns[i], JcrColumn.class, (String)("column[" + i + "]")));
            }
        }
        ArrayList<Object> jcrOrderings = null;
        if (orderings != null) {
            jcrOrderings = new ArrayList<Object>();
            for (int i = 0; i != orderings.length; ++i) {
                jcrOrderings.add(CheckArg.getInstanceOf((Object)orderings[i], JcrOrdering.class, (String)("orderings[" + i + "]")));
            }
        }
        JcrLimit jcrLimit = limit == null ? JcrLimit.NONE : new JcrLimit(limit.getRowLimit(), limit.getOffset());
        return new JcrSelectQuery(jcrSource, jcrConstraint, jcrOrderings, jcrColumns, jcrLimit, distinct);
    }

    public SetQuery union(QueryCommand left, QueryCommand right, Ordering[] orderings, Limit limit, boolean all) {
        return this.setQuery(left, SetQuery.Operation.UNION, right, orderings, limit, all);
    }

    public SetQuery intersect(QueryCommand left, QueryCommand right, Ordering[] orderings, Limit limit, boolean all) {
        return this.setQuery(left, SetQuery.Operation.INTERSECT, right, orderings, limit, all);
    }

    public SetQuery except(QueryCommand left, QueryCommand right, Ordering[] orderings, Limit limit, boolean all) {
        return this.setQuery(left, SetQuery.Operation.EXCEPT, right, orderings, limit, all);
    }

    public JcrSetQuery setQuery(QueryCommand left, SetQuery.Operation operation, QueryCommand right, Ordering[] orderings, Limit limit, boolean all) {
        JcrQueryCommand jcrLeft = (JcrQueryCommand)CheckArg.getInstanceOf((Object)left, JcrQueryCommand.class, (String)"left");
        JcrQueryCommand jcrRight = (JcrQueryCommand)CheckArg.getInstanceOf((Object)left, JcrQueryCommand.class, (String)"left");
        ArrayList<Object> jcrOrderings = new ArrayList<Object>();
        for (int i = 0; i != orderings.length; ++i) {
            jcrOrderings.add(CheckArg.getInstanceOf((Object)orderings[i], JcrOrdering.class, (String)("orderings[" + i + "]")));
        }
        JcrLimit jcrLimit = limit == null ? JcrLimit.NONE : new JcrLimit(limit.getRowLimit(), limit.getOffset());
        return new JcrSetQuery(jcrLeft, operation, jcrRight, all, jcrOrderings, jcrLimit);
    }

    public JcrNamedSelector selector(String nodeTypeName, String selectorName) {
        CheckArg.isNotNull((Object)nodeTypeName, (String)"nodeTypeName");
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new JcrNamedSelector(this.selectorName(nodeTypeName), this.selectorName(selectorName));
    }

    public JcrColumn column(String selectorName, String propertyName, String columnName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        if (propertyName == null) {
            return new JcrColumn(this.selectorName(selectorName));
        }
        CheckArg.isNotNull((Object)columnName, (String)"columnName");
        return new JcrColumn(this.selectorName(selectorName), selectorName, columnName);
    }

    public JcrOrdering ascending(DynamicOperand operand) {
        JcrDynamicOperand jcrOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand, JcrDynamicOperand.class, (String)"operand");
        return new JcrOrdering(jcrOperand, Order.ASCENDING);
    }

    public JcrOrdering descending(DynamicOperand operand) {
        JcrDynamicOperand jcrOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand, JcrDynamicOperand.class, (String)"operand");
        return new JcrOrdering(jcrOperand, Order.DESCENDING);
    }

    public And and(Constraint constraint1, Constraint constraint2) {
        JcrConstraint jcrConstraint1 = (JcrConstraint)CheckArg.getInstanceOf((Object)constraint1, JcrConstraint.class, (String)"constraint1");
        JcrConstraint jcrConstraint2 = (JcrConstraint)CheckArg.getInstanceOf((Object)constraint2, JcrConstraint.class, (String)"constraint2");
        return new JcrAnd(jcrConstraint1, jcrConstraint2);
    }

    public BindVariableValue bindVariable(String bindVariableName) {
        CheckArg.isNotNull((Object)bindVariableName, (String)"bindVariableName");
        return new JcrBindVariableName(bindVariableName);
    }

    public ChildNode childNode(String selectorName, String path) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)path, (String)"path");
        return new JcrChildNode(this.selectorName(selectorName), path);
    }

    public ChildNodeJoinCondition childNodeJoinCondition(String childSelectorName, String parentSelectorName) {
        CheckArg.isNotNull((Object)childSelectorName, (String)"childSelectorName");
        CheckArg.isNotNull((Object)parentSelectorName, (String)"parentSelectorName");
        return new JcrChildNodeJoinCondition(this.selectorName(parentSelectorName), this.selectorName(childSelectorName));
    }

    public Comparison comparison(DynamicOperand operand1, String operator, StaticOperand operand2) {
        JcrDynamicOperand jcrOperand1 = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand1, JcrDynamicOperand.class, (String)"operand1");
        CheckArg.isNotEmpty((String)operator, (String)"operator");
        JcrStaticOperand jcrOperand2 = (JcrStaticOperand)CheckArg.getInstanceOf((Object)operand2, JcrStaticOperand.class, (String)"operand2");
        operator = operator.trim();
        Operator op = null;
        if ("jcr.operator.equal.to".equals(operator)) {
            op = Operator.EQUAL_TO;
        } else if ("jcr.operator.greater.than".equals(operator)) {
            op = Operator.GREATER_THAN;
        } else if ("jcr.operator.greater.than.or.equal.to".equals(operator)) {
            op = Operator.GREATER_THAN_OR_EQUAL_TO;
        } else if ("jcr.operator.less.than".equals(operator)) {
            op = Operator.LESS_THAN;
        } else if ("jcr.operator.less.than.or.equal.to".equals(operator)) {
            op = Operator.LESS_THAN_OR_EQUAL_TO;
        } else if ("jcr.operator.like".equals(operator)) {
            op = Operator.LIKE;
        } else if ("jcr.operator.not.equal.to".equals(operator)) {
            op = Operator.NOT_EQUAL_TO;
        }
        if (op == null) {
            throw new IllegalArgumentException("Unknown or unsupported comparison operator: " + operator);
        }
        return new JcrComparison(jcrOperand1, op, jcrOperand2);
    }

    public DescendantNode descendantNode(String selectorName, String path) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)path, (String)"path");
        return new JcrDescendantNode(this.selectorName(selectorName), path);
    }

    public DescendantNodeJoinCondition descendantNodeJoinCondition(String descendantSelectorName, String ancestorSelectorName) {
        CheckArg.isNotNull((Object)descendantSelectorName, (String)"descendantSelectorName");
        CheckArg.isNotNull((Object)ancestorSelectorName, (String)"ancestorSelectorName");
        return new JcrDescendantNodeJoinCondition(this.selectorName(ancestorSelectorName), this.selectorName(descendantSelectorName));
    }

    public EquiJoinCondition equiJoinCondition(String selector1Name, String property1Name, String selector2Name, String property2Name) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)property1Name, (String)"property1Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        return new JcrEquiJoinCondition(this.selectorName(selector1Name), property1Name, this.selectorName(selector2Name), selector2Name);
    }

    public FullTextSearch fullTextSearch(String selectorName, String propertyName, StaticOperand fullTextSearchExpression) throws RepositoryException {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)fullTextSearchExpression, (String)"fullTextSearchExpression");
        return new JcrFullTextSearch(this.selectorName(selectorName), propertyName, fullTextSearchExpression);
    }

    public FullTextSearchScore fullTextSearchScore(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new JcrFullTextSearchScore(this.selectorName(selectorName));
    }

    public Join join(Source left, Source right, String joinType, JoinCondition joinCondition) {
        JcrSource leftSource = (JcrSource)CheckArg.getInstanceOf((Object)left, JcrSource.class, (String)"left");
        JcrSource rightSource = (JcrSource)CheckArg.getInstanceOf((Object)right, JcrSource.class, (String)"right");
        JcrJoinCondition jcrJoinCondition = (JcrJoinCondition)CheckArg.getInstanceOf((Object)joinCondition, JcrJoinCondition.class, (String)"joinCondition");
        CheckArg.isNotEmpty((String)joinType, (String)"joinType");
        joinType = joinType.trim();
        JoinType type = null;
        if ("jcr.join.type.cross".equals(joinType)) {
            type = JoinType.CROSS;
        } else if ("jcr.join.type.inner".equals(joinType)) {
            type = JoinType.INNER;
        } else if ("jcr.join.type.full.outer".equals(joinType)) {
            type = JoinType.FULL_OUTER;
        } else if ("jcr.join.type.left.outer".equals(joinType)) {
            type = JoinType.LEFT_OUTER;
        } else if ("jcr.join.type.right.outer".equals(joinType)) {
            type = JoinType.RIGHT_OUTER;
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown or unsupported join type: " + joinType);
        }
        return new JcrJoin(leftSource, type, rightSource, jcrJoinCondition);
    }

    public Length length(PropertyValue propertyValue) {
        JcrPropertyValue jcrPropValue = (JcrPropertyValue)CheckArg.getInstanceOf((Object)propertyValue, JcrPropertyValue.class, (String)"propertyValue");
        return new JcrLength(jcrPropValue);
    }

    public Literal literal(Value literalValue) throws RepositoryException {
        CheckArg.isNotNull((Object)literalValue, (String)"literalValue");
        return new JcrLiteral(literalValue);
    }

    public LowerCase lowerCase(DynamicOperand operand) {
        JcrDynamicOperand jcrOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand, JcrDynamicOperand.class, (String)"operand");
        return new JcrLowerCase(jcrOperand);
    }

    public NodeLocalName nodeLocalName(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new JcrNodeLocalName(this.selectorName(selectorName));
    }

    public NodeName nodeName(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new JcrNodeName(this.selectorName(selectorName));
    }

    public Not not(Constraint constraint) {
        JcrConstraint jcrConstraint = (JcrConstraint)CheckArg.getInstanceOf((Object)constraint, JcrConstraint.class, (String)"constraint");
        return new JcrNot(jcrConstraint);
    }

    public Or or(Constraint constraint1, Constraint constraint2) {
        JcrConstraint jcrConstraint1 = (JcrConstraint)CheckArg.getInstanceOf((Object)constraint1, JcrConstraint.class, (String)"constraint1");
        JcrConstraint jcrConstraint2 = (JcrConstraint)CheckArg.getInstanceOf((Object)constraint2, JcrConstraint.class, (String)"constraint2");
        return new JcrOr(jcrConstraint1, jcrConstraint2);
    }

    public PropertyExistence propertyExistence(String selectorName, String propertyName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        return new JcrPropertyExistence(this.selectorName(selectorName), propertyName);
    }

    public PropertyValue propertyValue(String selectorName, String propertyName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        return new JcrPropertyValue(this.selectorName(selectorName), propertyName);
    }

    public SameNode sameNode(String selectorName, String path) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)path, (String)"path");
        return new JcrSameNode(this.selectorName(selectorName), path);
    }

    public SameNodeJoinCondition sameNodeJoinCondition(String selector1Name, String selector2Name, String selector2Path) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        return new JcrSameNodeJoinCondition(this.selectorName(selector1Name), this.selectorName(selector1Name), selector2Path);
    }

    public UpperCase upperCase(DynamicOperand operand) {
        JcrDynamicOperand jcrOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand, JcrDynamicOperand.class, (String)"operand");
        return new JcrUpperCase(jcrOperand);
    }

    public NodePath nodePath(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new JcrNodePath(this.selectorName(selectorName));
    }

    public NodeDepth nodeDepth(String selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        return new JcrNodeDepth(this.selectorName(selectorName));
    }

    public Limit limit(int rowLimit, int offset) {
        CheckArg.isPositive((int)rowLimit, (String)"rowLimit");
        CheckArg.isNonNegative((int)offset, (String)"offset");
        return new JcrLimit(rowLimit, offset);
    }

    public Between between(DynamicOperand operand, StaticOperand lowerBound, StaticOperand upperBound, boolean includeLowerBound, boolean includeUpperBound) {
        JcrDynamicOperand jcrOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand, JcrDynamicOperand.class, (String)"operand");
        JcrStaticOperand lower = (JcrStaticOperand)CheckArg.getInstanceOf((Object)lowerBound, JcrStaticOperand.class, (String)"lowerBound");
        JcrStaticOperand upper = (JcrStaticOperand)CheckArg.getInstanceOf((Object)upperBound, JcrStaticOperand.class, (String)"upperBound");
        return new JcrBetween(jcrOperand, lower, upper, includeLowerBound, includeUpperBound);
    }

    public SetCriteria in(DynamicOperand operand, StaticOperand ... values) {
        JcrDynamicOperand jcrOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)operand, JcrDynamicOperand.class, (String)"operand");
        ArrayList<JcrStaticOperand> jcrValues = new ArrayList<JcrStaticOperand>();
        for (StaticOperand value : values) {
            JcrStaticOperand jcrValue = (JcrStaticOperand)CheckArg.getInstanceOf((Object)value, JcrStaticOperand.class, (String)"values");
            jcrValues.add(jcrValue);
        }
        return new JcrSetCriteria(jcrOperand, jcrValues);
    }

    public Subquery subquery(QueryCommand subqueryCommand) {
        JcrQueryCommand jcrCommand = (JcrQueryCommand)CheckArg.getInstanceOf((Object)subqueryCommand, JcrQueryCommand.class, (String)"subqueryCommand");
        return new JcrSubquery(jcrCommand);
    }

    public ArithmeticOperand add(DynamicOperand left, DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.ADD, right);
    }

    public ArithmeticOperand subtract(DynamicOperand left, DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.SUBTRACT, right);
    }

    public ArithmeticOperand multiply(DynamicOperand left, DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.MULTIPLY, right);
    }

    public ArithmeticOperand divide(DynamicOperand left, DynamicOperand right) {
        return this.arithmeticOperand(left, ArithmeticOperator.DIVIDE, right);
    }

    public ArithmeticOperand arithmeticOperand(DynamicOperand left, ArithmeticOperator operator, DynamicOperand right) {
        JcrDynamicOperand leftOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)left, JcrDynamicOperand.class, (String)"left");
        JcrDynamicOperand rightOperand = (JcrDynamicOperand)CheckArg.getInstanceOf((Object)left, JcrDynamicOperand.class, (String)"left");
        return new JcrArithmeticOperand(leftOperand, operator, rightOperand);
    }

    public JcrReferenceValue referenceValue(String selectorName) {
        return new JcrReferenceValue(this.selectorName(selectorName), null);
    }

    public JcrReferenceValue referenceValue(String selectorName, String propertyName) {
        return new JcrReferenceValue(this.selectorName(selectorName), propertyName);
    }
}

