/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private InputStream wrappedInputStream;
    private long currentByte;
    private long markedByte;

    public CountingInputStream(InputStream inputStream) {
        this.wrappedInputStream = inputStream;
    }

    public long getCurrentByte() {
        return this.currentByte;
    }

    public int available() throws IOException {
        return this.wrappedInputStream.available();
    }

    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    public boolean equals(Object object) {
        return this.wrappedInputStream.equals(object);
    }

    public int hashCode() {
        return this.wrappedInputStream.hashCode();
    }

    public void mark(int n) {
        this.wrappedInputStream.mark(n);
        this.markedByte = this.currentByte;
    }

    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    public int read() throws IOException {
        ++this.currentByte;
        return this.wrappedInputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.wrappedInputStream.read(byArray, n, n2);
        this.currentByte += (long)n3;
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.wrappedInputStream.read(byArray);
        this.currentByte += (long)n;
        return n;
    }

    public void reset() throws IOException {
        this.wrappedInputStream.reset();
        this.currentByte = this.markedByte;
    }

    public long skip(long l) throws IOException {
        long l2 = this.wrappedInputStream.skip(l);
        this.currentByte += l2;
        return l2;
    }

    public String toString() {
        return this.wrappedInputStream.toString();
    }
}

