/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.socketfactory.standard;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.semanticdesktop.aperture.security.trustmanager.standard.StandardTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;

    public StandardSocketFactory() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{new StandardTrustManager()}, null);
            this.factory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Exception while instantiating a StandardSocketFactory", (Throwable)exception);
        }
    }

    public static SocketFactory getDefault() {
        return new StandardSocketFactory();
    }

    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.factory.createSocket(socket, string, n, bl);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.factory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.factory.createSocket(inetAddress, n);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.factory.createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this.factory.createSocket(string, n);
    }

    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

