/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Value;
import org.apache.lucene.document.Field;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.LinkedHashMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class NodeTypeSchemata
implements Schemata {
    protected static final boolean DEFAULT_CAN_CONTAIN_REFERENCES = true;
    protected static final boolean DEFAULT_FULL_TEXT_SEARCHABLE = true;
    private final Schemata schemata;
    private final Map<Integer, String> types;
    private final Map<String, String> prefixesByUris = new HashMap<String, String>();
    private final boolean includeColumnsForInheritedProperties;
    private final boolean includePseudoColumnsInSelectStar;
    private final Collection<JcrPropertyDefinition> propertyDefinitions;
    private final Map<Name, JcrNodeType> nodeTypesByName;
    private final Multimap<JcrNodeType, JcrNodeType> subtypesByName = LinkedHashMultimap.create();
    private final IndexRules indexRules;
    private final List<JcrPropertyDefinition> pseudoProperties = new ArrayList<JcrPropertyDefinition>();

    NodeTypeSchemata(ExecutionContext context, Map<Name, JcrNodeType> nodeTypes, Collection<JcrPropertyDefinition> propertyDefinitions, boolean includeColumnsForInheritedProperties, boolean includePseudoColumnsInSelectStar) {
        this.includeColumnsForInheritedProperties = includeColumnsForInheritedProperties;
        this.includePseudoColumnsInSelectStar = includePseudoColumnsInSelectStar;
        this.propertyDefinitions = propertyDefinitions;
        this.nodeTypesByName = nodeTypes;
        for (NamespaceRegistry.Namespace namespace : context.getNamespaceRegistry().getNamespaces()) {
            this.prefixesByUris.put(namespace.getNamespaceUri(), namespace.getPrefix());
        }
        for (JcrNodeType nodeType : this.nodeTypesByName.values()) {
            for (JcrNodeType supertype : nodeType.getTypeAndSupertypes()) {
                this.subtypesByName.put((Object)supertype, (Object)nodeType);
            }
        }
        TypeSystem typeSystem = context.getValueFactories().getTypeSystem();
        ImmutableSchemata.Builder builder = ImmutableSchemata.createBuilder((TypeSystem)typeSystem);
        this.types = new HashMap<Integer, String>();
        this.types.put(2, typeSystem.getBinaryFactory().getTypeName());
        this.types.put(6, typeSystem.getBooleanFactory().getTypeName());
        this.types.put(5, typeSystem.getDateTimeFactory().getTypeName());
        this.types.put(12, typeSystem.getDecimalFactory().getTypeName());
        this.types.put(4, typeSystem.getDoubleFactory().getTypeName());
        this.types.put(3, typeSystem.getLongFactory().getTypeName());
        this.types.put(8, typeSystem.getStringFactory().getTypeName());
        this.types.put(9, typeSystem.getReferenceFactory().getTypeName());
        this.types.put(10, typeSystem.getReferenceFactory().getTypeName());
        this.types.put(1, typeSystem.getStringFactory().getTypeName());
        this.types.put(7, typeSystem.getStringFactory().getTypeName());
        this.types.put(11, typeSystem.getStringFactory().getTypeName());
        this.pseudoProperties.add(this.pseudoProperty(context, JcrLexicon.PATH, 1));
        this.pseudoProperties.add(this.pseudoProperty(context, JcrLexicon.NAME, 1));
        this.pseudoProperties.add(this.pseudoProperty(context, JcrLexicon.SCORE, 4));
        this.pseudoProperties.add(this.pseudoProperty(context, ModeShapeLexicon.LOCALNAME, 1));
        this.pseudoProperties.add(this.pseudoProperty(context, ModeShapeLexicon.DEPTH, 3));
        IndexRules.Builder indexRulesBuilder = IndexRules.createBuilder((IndexRules)LuceneSearchEngine.DEFAULT_RULES);
        indexRulesBuilder.defaultTo(Field.Store.YES, Field.Index.ANALYZED, true, true);
        this.addAllNodesTable(builder, indexRulesBuilder, context, this.pseudoProperties);
        for (JcrNodeType nodeType : this.nodeTypesByName.values()) {
            this.addView(builder, context, nodeType);
        }
        this.schemata = builder.build();
        this.indexRules = indexRulesBuilder.build();
    }

    protected JcrPropertyDefinition pseudoProperty(ExecutionContext context, Name name, int propertyType) {
        int opv = 5;
        boolean autoCreated = true;
        boolean mandatory = true;
        boolean isProtected = true;
        boolean multiple = false;
        boolean fullTextSearchable = false;
        boolean queryOrderable = true;
        Value[] defaultValues = null;
        String[] valueConstraints = new String[]{};
        String[] queryOperators = null;
        return new JcrPropertyDefinition(context, null, name, opv, autoCreated, mandatory, isProtected, defaultValues, propertyType, valueConstraints, multiple, fullTextSearchable, queryOrderable, queryOperators);
    }

    public IndexRules getIndexRules() {
        return this.indexRules;
    }

    protected JcrNodeType getNodeType(Name nodeTypeName) {
        return this.nodeTypesByName.get(nodeTypeName);
    }

    protected final void addAllNodesTable(ImmutableSchemata.Builder builder, IndexRules.Builder indexRuleBuilder, ExecutionContext context, List<JcrPropertyDefinition> additionalProperties) {
        Set<Operator> operators;
        boolean orderable;
        NamespaceRegistry registry = context.getNamespaceRegistry();
        TypeSystem typeSystem = context.getValueFactories().getTypeSystem();
        String tableName = AllNodes.ALL_NODES_NAME.name();
        boolean first = true;
        HashMap<String, String> typesForNames = new HashMap<String, String>();
        HashSet<String> fullTextSearchableNames = new HashSet<String>();
        for (JcrPropertyDefinition defn : this.propertyDefinitions) {
            boolean fullTextSearchable;
            if (defn.isResidual() || defn.isPrivate()) continue;
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                builder.addTable(tableName, new String[]{columnName});
                first = false;
            }
            boolean canBeReference = false;
            boolean isStrongReference = false;
            switch (defn.getRequiredType()) {
                case 9: {
                    isStrongReference = true;
                    canBeReference = true;
                    break;
                }
                case 0: 
                case 10: {
                    canBeReference = true;
                }
            }
            String type = typeSystem.getDefaultType();
            if (defn.getRequiredType() != 0) {
                type = this.types.get(defn.getRequiredType());
            }
            assert (type != null);
            String previousType = typesForNames.put(columnName, type);
            if (previousType != null && !previousType.equals(type)) {
                type = typeSystem.getCompatibleType(previousType, type);
            }
            boolean bl = fullTextSearchable = fullTextSearchableNames.contains(columnName) || defn.isFullTextSearchable();
            if (fullTextSearchable) {
                fullTextSearchableNames.add(columnName);
            }
            orderable = defn.isQueryOrderable();
            operators = this.operatorsFor(defn);
            builder.addColumn(tableName, columnName, type, fullTextSearchable, orderable, operators);
            if (indexRuleBuilder == null) continue;
            this.addIndexRule(indexRuleBuilder, defn, type, typeSystem, canBeReference, isStrongReference);
        }
        if (additionalProperties != null) {
            boolean canBeReference = false;
            boolean isStrongReference = false;
            boolean fullTextSearchable = false;
            assert (!first);
            for (JcrPropertyDefinition defn : additionalProperties) {
                Name name = defn.getInternalName();
                String columnName = name.getString(registry);
                assert (defn.getRequiredType() != 0);
                String type = this.types.get(defn.getRequiredType());
                assert (type != null);
                String previousType = typesForNames.put(columnName, type);
                if (previousType != null && !previousType.equals(type)) {
                    type = typeSystem.getCompatibleType(previousType, type);
                }
                orderable = defn.isQueryOrderable();
                operators = this.operatorsFor(defn);
                builder.addColumn(tableName, columnName, type, fullTextSearchable, orderable, operators);
                if (!this.includePseudoColumnsInSelectStar) {
                    builder.excludeFromSelectStar(tableName, columnName);
                }
                if (indexRuleBuilder == null) continue;
                this.addIndexRule(indexRuleBuilder, defn, type, typeSystem, canBeReference, isStrongReference);
            }
        }
    }

    protected Set<Operator> operatorsFor(JcrPropertyDefinition defn) {
        String[] ops = defn.getAvailableQueryOperators();
        if (ops == null || ops.length == 0) {
            return EnumSet.allOf(Operator.class);
        }
        HashSet<Operator> result = new HashSet<Operator>();
        for (String symbol : ops) {
            Operator op = JcrPropertyDefinition.operatorFromSymbol(symbol);
            assert (op != null);
            result.add(op);
        }
        return result;
    }

    protected final void addIndexRule(IndexRules.Builder builder, JcrPropertyDefinition defn, String type, TypeSystem typeSystem, boolean canBeReference, boolean isStrongReference) {
        Field.Index index;
        Field.Store store = Field.Store.YES;
        Field.Index index2 = index = defn.isFullTextSearchable() ? Field.Index.ANALYZED : Field.Index.NO;
        if (typeSystem.getStringFactory().getTypeName().equals(type)) {
            builder.stringField(defn.getInternalName(), store, index, canBeReference, defn.isFullTextSearchable());
        } else if (typeSystem.getDateTimeFactory().getTypeName().equals(type)) {
            Long minimum = (Long)typeSystem.getLongFactory().create(defn.getMinimumValue());
            Long maximum = (Long)typeSystem.getLongFactory().create(defn.getMaximumValue());
            builder.dateField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getLongFactory().getTypeName().equals(type)) {
            Long minimum = (Long)typeSystem.getLongFactory().create(defn.getMinimumValue());
            Long maximum = (Long)typeSystem.getLongFactory().create(defn.getMaximumValue());
            builder.longField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getDoubleFactory().getTypeName().equals(type)) {
            Double minimum = (Double)typeSystem.getDoubleFactory().create(defn.getMinimumValue());
            Double maximum = (Double)typeSystem.getDoubleFactory().create(defn.getMaximumValue());
            builder.doubleField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getBooleanFactory().getTypeName().equals(type)) {
            builder.booleanField(defn.getInternalName(), store, index);
        } else if (typeSystem.getBinaryFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.binaryField(defn.getInternalName(), store, index, defn.isFullTextSearchable());
        } else if (typeSystem.getReferenceFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.referenceField(defn.getInternalName(), store, index);
        } else if (typeSystem.getPathFactory().getTypeName().equals(type)) {
            builder.pathField(defn.getInternalName(), store, index);
        } else {
            builder.stringField(defn.getInternalName(), store, index, canBeReference, defn.isFullTextSearchable());
        }
    }

    protected final void addView(ImmutableSchemata.Builder builder, ExecutionContext context, JcrNodeType nodeType) {
        NamespaceRegistry registry = context.getNamespaceRegistry();
        if (!nodeType.isQueryable()) {
            return;
        }
        String tableName = nodeType.getName();
        JcrPropertyDefinition[] defns = null;
        defns = this.includeColumnsForInheritedProperties ? nodeType.getPropertyDefinitions() : nodeType.getDeclaredPropertyDefinitions();
        StringBuilder viewDefinition = new StringBuilder("SELECT ");
        boolean hasResidualProperties = false;
        boolean first = true;
        for (JcrPropertyDefinition defn : defns) {
            if (defn.isResidual()) {
                hasResidualProperties = true;
                continue;
            }
            if (defn.isMultiple() || defn.isPrivate()) continue;
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                first = false;
            } else {
                viewDefinition.append(',');
            }
            viewDefinition.append('[').append(columnName).append(']');
            if (!defn.isQueryOrderable()) {
                builder.markOrderable(tableName, columnName, false);
            }
            builder.markOperators(tableName, columnName, this.operatorsFor(defn));
        }
        for (JcrPropertyDefinition defn : this.pseudoProperties) {
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                first = false;
            } else {
                viewDefinition.append(',');
            }
            viewDefinition.append('[').append(columnName).append(']');
            builder.markOperators(tableName, columnName, this.operatorsFor(defn));
        }
        if (first) {
            return;
        }
        viewDefinition.append(" FROM ").append(AllNodes.ALL_NODES_NAME).append(" AS [").append(tableName).append(']');
        if (!JcrNtLexicon.BASE.equals(nodeType.getInternalName())) {
            viewDefinition.append(" WHERE ");
            int mixinTypeCount = 0;
            int primaryTypeCount = 0;
            StringBuilder mixinTypes = new StringBuilder();
            StringBuilder primaryTypes = new StringBuilder();
            Collection typeAndSubtypes = this.subtypesByName.get((Object)nodeType);
            for (JcrNodeType thisOrSupertype : typeAndSubtypes) {
                String name;
                if (thisOrSupertype.isMixin()) {
                    if (mixinTypeCount > 0) {
                        mixinTypes.append(',');
                    }
                    assert (this.prefixesByUris.containsKey(thisOrSupertype.getInternalName().getNamespaceUri()));
                    name = thisOrSupertype.getInternalName().getString(registry);
                    mixinTypes.append('[').append(name).append(']');
                    ++mixinTypeCount;
                    continue;
                }
                if (primaryTypeCount > 0) {
                    primaryTypes.append(',');
                }
                assert (this.prefixesByUris.containsKey(thisOrSupertype.getInternalName().getNamespaceUri()));
                name = thisOrSupertype.getInternalName().getString(registry);
                primaryTypes.append('[').append(name).append(']');
                ++primaryTypeCount;
            }
            if (primaryTypeCount > 0) {
                viewDefinition.append('[').append(JcrLexicon.PRIMARY_TYPE.getString(registry)).append(']');
                if (primaryTypeCount == 1) {
                    viewDefinition.append('=').append((CharSequence)primaryTypes);
                } else {
                    viewDefinition.append(" IN (").append((CharSequence)primaryTypes).append(')');
                }
            }
            if (mixinTypeCount > 0) {
                if (primaryTypeCount > 0) {
                    viewDefinition.append(" OR ");
                }
                viewDefinition.append('[').append(JcrLexicon.MIXIN_TYPES.getString(registry)).append(']');
                if (mixinTypeCount == 1) {
                    viewDefinition.append('=').append((CharSequence)mixinTypes);
                } else {
                    viewDefinition.append(" IN (").append((CharSequence)mixinTypes).append(')');
                }
            }
        }
        builder.addView(tableName, viewDefinition.toString());
        if (hasResidualProperties) {
            builder.markExtraColumns(tableName);
        }
    }

    public Schemata.Table getTable(SelectorName name) {
        return this.schemata.getTable(name);
    }

    public Schemata getSchemataForSession(JcrSession session) {
        assert (session != null);
        if (!this.overridesNamespaceMappings(session)) {
            return this;
        }
        return new SessionSchemata(session);
    }

    private boolean overridesNamespaceMappings(JcrSession session) {
        NamespaceRegistry registry = session.getExecutionContext().getNamespaceRegistry();
        if (registry instanceof LocalNamespaceRegistry) {
            LocalNamespaceRegistry localRegistry = (LocalNamespaceRegistry)registry;
            Set localNamespaces = localRegistry.getLocalNamespaces();
            if (localNamespaces.isEmpty()) {
                return false;
            }
            NamespaceRegistry global = localRegistry.getDelegate();
            for (NamespaceRegistry.Namespace namespace : localNamespaces) {
                String uri = namespace.getNamespaceUri();
                String globalPrefix = global.getPrefixForNamespaceUri(uri, false);
                if (namespace.getPrefix().equals(globalPrefix) || !this.prefixesByUris.containsKey(uri)) continue;
                return true;
            }
            return false;
        }
        for (NamespaceRegistry.Namespace namespace : registry.getNamespaces()) {
            String expectedPrefix = this.prefixesByUris.get(namespace.getNamespaceUri());
            if (expectedPrefix == null || namespace.getPrefix().equals(expectedPrefix)) continue;
            return true;
        }
        return false;
    }

    @NotThreadSafe
    protected class SessionSchemata
    implements Schemata {
        private final JcrSession session;
        private final ExecutionContext context;
        private final ImmutableSchemata.Builder builder;
        private final NameFactory nameFactory;
        private Schemata schemata;

        protected SessionSchemata(JcrSession session) {
            this.session = session;
            this.context = this.session.getExecutionContext();
            this.nameFactory = this.context.getValueFactories().getNameFactory();
            this.builder = ImmutableSchemata.createBuilder((TypeSystem)this.context.getValueFactories().getTypeSystem());
            NodeTypeSchemata.this.addAllNodesTable(this.builder, null, this.context, NodeTypeSchemata.this.pseudoProperties);
            this.schemata = this.builder.build();
        }

        public Schemata.Table getTable(SelectorName name) {
            Schemata.Table table = this.schemata.getTable(name);
            if (table == null) {
                Name nodeTypeName = (Name)this.nameFactory.create(name.name());
                JcrNodeType nodeType = NodeTypeSchemata.this.getNodeType(nodeTypeName);
                if (nodeType == null) {
                    return null;
                }
                NodeTypeSchemata.this.addView(this.builder, this.context, nodeType);
                this.schemata = this.builder.build();
            }
            return this.schemata.getTable(name);
        }
    }
}

