/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jbosscache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.cache.Cache;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.connector.jbosscache.JBossCacheNode;
import org.modeshape.connector.jbosscache.JBossCacheSource;
import org.modeshape.connector.jbosscache.JBossCacheTransaction;
import org.modeshape.connector.jbosscache.JBossCacheWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Repository;

@ThreadSafe
public class JBossCacheRepository
extends Repository<JBossCacheNode, JBossCacheWorkspace> {
    private final Cache<UUID, JBossCacheNode> cache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<String> predefinedWorkspaceNames;

    public JBossCacheRepository(JBossCacheSource source, Cache<UUID, JBossCacheNode> cache) {
        super((BaseRepositorySource)source);
        this.cache = cache;
        assert (this.cache != null);
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : source.getPredefinedWorkspaceNames()) {
            workspaceNames.add(workspaceName);
        }
        this.predefinedWorkspaceNames = Collections.unmodifiableSet(workspaceNames);
        this.initialize();
    }

    public Set<String> getWorkspaceNames() {
        HashSet<String> names = new HashSet<String>(super.getWorkspaceNames());
        names.addAll(this.predefinedWorkspaceNames);
        return Collections.unmodifiableSet(names);
    }

    public Cache<UUID, JBossCacheNode> getCache() {
        return this.cache;
    }

    public void shutdown() {
    }

    public JBossCacheTransaction startTransaction(ExecutionContext context, boolean readonly) {
        Lock lock = readonly ? this.lock.readLock() : this.lock.writeLock();
        lock.lock();
        return new JBossCacheTransaction(context, this, this.getRootNodeUuid(), lock);
    }
}

