/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAccessData
implements AccessData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NS_MAD_STRING = "http://aperture.sourceforge.net/2007/07/19/mad#";
    public static final URI NS_MAD = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#");
    public static final URI linksTo = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#linksTo");
    public static final URI aggregates = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#aggregates");
    public static final URI redirectsTo = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#redirectsTo");
    public static final URI dateAsNumber = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#dateAsNumber");
    public static final URI byteSize = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#byteSize");
    public static final URI timestamp = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#timestamp");
    public static final String URI_PREFIX = "urn:accessdata:";
    private Model model;
    private long timestampLong = -1L;

    public ModelAccessData(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.timestampLong = -1L;
    }

    private void checkInitialization() {
        if (this.timestampLong < 0L) {
            throw new IllegalStateException("AccessData not initialized, call initialize() first");
        }
    }

    @Override
    public void clear() throws IOException {
        this.timestampLong = -1L;
        try {
            this.model.removeAll();
        }
        catch (ModelRuntimeException modelRuntimeException) {
            IOException iOException = new IOException();
            iOException.initCause(modelRuntimeException);
            throw iOException;
        }
    }

    @Override
    public void touch(String string) {
        URI uRI = this.model.createURI(string);
        this.touch(uRI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTouched(String string) {
        URI uRI = this.model.createURI(string);
        ClosableIterator closableIterator = null;
        try {
            closableIterator = this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)timestamp, (NodeOrVariable)Variable.ANY);
            if (!closableIterator.hasNext()) {
                boolean bl = false;
                return bl;
            }
            Statement statement = (Statement)closableIterator.next();
            boolean bl = this.checkTouched(statement.getObject());
            closableIterator.close();
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    private void touch(URI uRI) {
        this.model.removeStatement((Resource)uRI, timestamp, (Node)null);
        try {
            this.model.addStatement((Resource)uRI, timestamp, (Node)ModelUtil.createLiteral(this.model, this.timestampLong));
        }
        catch (ModelException modelException) {
            throw new ModelRuntimeException((Throwable)modelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String string, String string2) {
        URI uRI;
        this.checkInitialization();
        this.commit();
        ClosableIterator closableIterator = null;
        try {
            Statement statement;
            URI uRI2 = ModelUtil.createURI(this.model, string);
            uRI = this.toURI(string2);
            closableIterator = this.model.findStatements((ResourceOrVariable)uRI2, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            if (closableIterator.hasNext()) {
                statement = (Statement)closableIterator.next();
                if (!closableIterator.hasNext()) {
                    Node node = statement.getObject();
                    if (node instanceof Literal) {
                        String string3 = ((Literal)node).getValue();
                        return string3;
                    }
                    if (node instanceof URI) {
                        String string4 = node.toString();
                        return string4;
                    }
                }
            }
            statement = null;
            return statement;
        }
        catch (ModelException modelException) {
            this.logger.error("Could not get value for id: '" + string + "' key: '" + string2 + "'", (Throwable)modelException);
            uRI = null;
            return uRI;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getReferredIDs(String string) {
        this.checkInitialization();
        this.commit();
        ClosableIterator closableIterator = null;
        HashSet<String> hashSet = null;
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            closableIterator = this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)linksTo, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Node node = statement.getObject();
                if (!(node instanceof URI)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(((URI)node).toString());
            }
        }
        catch (ModelException modelException) {
            this.logger.error("Could not get referred id's", (Throwable)modelException);
            Set<String> set = null;
            return set;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return hashSet;
    }

    @Override
    public int getSize() {
        this.checkInitialization();
        return this.getStoredIDs().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStoredIDs() {
        this.checkInitialization();
        this.commit();
        ClosableIterator closableIterator = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            closableIterator = this.model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                hashSet.add(((Statement)closableIterator.next()).getSubject().toString());
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.warn("Couldn't get stored IDs", (Throwable)modelRuntimeException);
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return hashSet;
    }

    @Override
    public void initialize() throws IOException {
        this.timestampLong = System.currentTimeMillis();
        this.safelySleep(2L);
    }

    private void safelySleep(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        while (l3 < l2 + l) {
            try {
                Thread.sleep(l2 + l - l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l3 = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKnownId(String string) {
        this.checkInitialization();
        this.commit();
        ClosableIterator closableIterator = null;
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            closableIterator = this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY);
            boolean bl = closableIterator.hasNext();
            return bl;
        }
        catch (ModelException modelException) {
            this.logger.error("Could not determine if an ID is known: " + string, (Throwable)modelException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    @Override
    public void put(String string, String string2, String string3) {
        this.checkInitialization();
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            URI uRI2 = this.toURI(string2);
            this.remove(uRI, uRI2);
            if (uRI2 == redirectsTo) {
                this.add(ModelUtil.createStatement(this.model, (Resource)uRI, uRI2, (Node)ModelUtil.createURI(this.model, string3)));
            } else {
                URI uRI3 = uRI2 == dateAsNumber || uRI2 == byteSize ? XSD._long : XSD._string;
                Literal literal = ModelUtil.createLiteral(this.model, string3, uRI3);
                this.add(ModelUtil.createStatement(this.model, (Resource)uRI, uRI2, (Node)literal));
            }
            this.add(this.model.createStatement((Resource)uRI, timestamp, (Node)ModelUtil.createLiteral(this.model, this.timestampLong)));
        }
        catch (ModelException modelException) {
            this.logger.error("Could not store info for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void putReferredID(String string, String string2) {
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            URI uRI2 = ModelUtil.createURI(this.model, string2);
            this.add(ModelUtil.createStatement(this.model, (Resource)uRI, linksTo, (Node)uRI2));
        }
        catch (ModelException modelException) {
            this.logger.error("Could not store referred ID for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void remove(String string, String string2) {
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            this.remove(uRI, this.toURI(string2));
        }
        catch (ModelException modelException) {
            this.logger.error("Could not remove value for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void remove(String string) {
        try {
            this.remove(ModelUtil.createURI(this.model, string), null);
        }
        catch (ModelException modelException) {
            this.logger.error("Could not remove info about ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void removeReferredID(String string, String string2) {
        this.commit();
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            URI uRI2 = ModelUtil.createURI(this.model, string2);
            Statement statement = ModelUtil.createStatement(this.model, (Resource)uRI, linksTo, (Node)uRI2);
            this.model.removeStatement(statement);
        }
        catch (ModelException modelException) {
            this.logger.error("Could not remove referred ID for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void removeReferredIDs(String string) {
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            this.remove(uRI, linksTo);
        }
        catch (ModelException modelException) {
            this.logger.error("Could not remove referred IDs for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void store() throws IOException {
        this.timestampLong = -1L;
        this.commit();
    }

    private void commit() {
    }

    private URI toURI(String string) throws ModelException {
        if (string == "date") {
            return dateAsNumber;
        }
        if (string == "byteSize") {
            return byteSize;
        }
        if (string == "redirectsTo") {
            return redirectsTo;
        }
        return ModelUtil.createURI(this.model, URI_PREFIX + string);
    }

    private void add(Statement statement) {
        try {
            this.model.addStatement(statement);
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("Exception while adding statement", (Throwable)modelRuntimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(URI uRI, URI uRI2) {
        this.commit();
        ClosableIterator closableIterator = null;
        try {
            if (uRI2 == null) {
                closableIterator = this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)aggregates, (NodeOrVariable)Variable.ANY);
                while (closableIterator.hasNext()) {
                    URI uRI3 = ((Statement)closableIterator.next()).getObject().asURI();
                    this.remove(uRI3, null);
                }
            }
            this.model.removeStatement((Resource)uRI, uRI2, (Node)null);
            this.model.removeStatement(null, aggregates, (Node)uRI);
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("Exception while removing statement", (Throwable)modelRuntimeException);
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getAggregatedIDs(String string) {
        this.commit();
        ClosableIterator closableIterator = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            closableIterator = this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)aggregates, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Node node = statement.getObject();
                if (!(node instanceof URI)) continue;
                hashSet.add(((URI)node).toString());
            }
        }
        catch (ModelException modelException) {
            this.logger.error("Could not get referred id's", (Throwable)modelException);
            Set set = null;
            return set;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return hashSet;
    }

    @Override
    public void putAggregatedID(String string, String string2) {
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            URI uRI2 = ModelUtil.createURI(this.model, string2);
            this.model.removeStatement(null, aggregates, (Node)uRI2);
            this.add(ModelUtil.createStatement(this.model, (Resource)uRI, aggregates, (Node)uRI2));
        }
        catch (ModelException modelException) {
            this.logger.error("Could not store referred ID for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void removeAggregatedID(String string, String string2) {
        this.commit();
        try {
            URI uRI = ModelUtil.createURI(this.model, string);
            URI uRI2 = ModelUtil.createURI(this.model, string2);
            Statement statement = ModelUtil.createStatement(this.model, (Resource)uRI, aggregates, (Node)uRI2);
            this.model.removeStatement(statement);
        }
        catch (ModelException modelException) {
            this.logger.error("Could not remove referred ID for ID " + string, (Throwable)modelException);
        }
    }

    @Override
    public void removeUntouchedIDs() {
        ClosableIterator closableIterator = null;
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        try {
            closableIterator = this.model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)timestamp, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Node node = statement.getObject();
                if (this.checkTouched(node)) continue;
                linkedList.add(statement.getSubject());
            }
            closableIterator.close();
            for (Resource resource : linkedList) {
                this.model.removeStatements((ResourceOrVariable)resource, (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY);
                this.model.removeStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)aggregates, (NodeOrVariable)resource);
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            throw modelRuntimeException;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    @Override
    public ClosableIterator getUntouchedIDsIterator() {
        return new UntouchedIterator((ClosableIterator<? extends Statement>)this.model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)timestamp, (NodeOrVariable)Variable.ANY));
    }

    private boolean checkTouched(Node node) {
        boolean bl = false;
        if (node instanceof Literal) {
            Literal literal = (Literal)node;
            String string = literal.getValue();
            try {
                long l = Long.valueOf(string);
                if (l == this.timestampLong) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void touchRecursively(String string) {
        URI uRI = this.model.createURI(string);
        this.touchURIRecursively(uRI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchURIRecursively(URI uRI) {
        this.touch(uRI);
        ClosableIterator closableIterator = null;
        try {
            closableIterator = this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)aggregates, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                this.touchURIRecursively(statement.getObject().asURI());
            }
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    @Override
    public ClosableIterator getAggregatedIDsClosure(String string) {
        URI uRI = this.model.createURI(string);
        return new AggregatedClosureIterator((ClosableIterator<? extends Statement>)this.model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)aggregates, (NodeOrVariable)Variable.ANY), string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregatedClosureIterator
    implements ClosableIterator {
        private List<ClosableIterator<? extends Statement>> iteratorStack;
        private String nextValue;

        public AggregatedClosureIterator(ClosableIterator<? extends Statement> closableIterator, String string) {
            this.nextValue = string;
            this.iteratorStack = new LinkedList<ClosableIterator<? extends Statement>>();
            this.iteratorStack.add(0, closableIterator);
        }

        public boolean hasNext() {
            this.getNextValue();
            return this.nextValue != null;
        }

        public Object next() {
            this.getNextValue();
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            String string = this.nextValue;
            this.nextValue = null;
            return string;
        }

        private void getNextValue() {
            if (this.nextValue != null) {
                return;
            }
            while (this.iteratorStack.size() > 0) {
                ClosableIterator<? extends Statement> closableIterator = this.iteratorStack.get(0);
                if (closableIterator.hasNext()) {
                    Statement statement = (Statement)closableIterator.next();
                    this.nextValue = statement.getSubject().toString();
                    this.iteratorStack.add(0, (ClosableIterator<? extends Statement>)ModelAccessData.this.model.findStatements((ResourceOrVariable)statement.getObject().asURI(), (UriOrVariable)aggregates, (NodeOrVariable)Variable.ANY));
                    break;
                }
                closableIterator.close();
                this.iteratorStack.remove(0);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            for (ClosableIterator<? extends Statement> closableIterator : this.iteratorStack) {
                closableIterator.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UntouchedIterator
    implements ClosableIterator {
        private ClosableIterator<? extends Statement> wrappedIterator;
        private String nextValue;

        public UntouchedIterator(ClosableIterator<? extends Statement> closableIterator) {
            this.wrappedIterator = closableIterator;
        }

        public boolean hasNext() {
            this.getNextUntouched();
            return this.nextValue != null;
        }

        public Object next() {
            this.getNextUntouched();
            String string = this.nextValue;
            this.nextValue = null;
            return string;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.wrappedIterator.close();
        }

        private void getNextUntouched() {
            if (this.nextValue == null) {
                while (this.wrappedIterator.hasNext()) {
                    Statement statement = (Statement)this.wrappedIterator.next();
                    Node node = statement.getObject();
                    boolean bl = ModelAccessData.this.checkTouched(node);
                    if (bl) continue;
                    this.nextValue = statement.getSubject().toString();
                    break;
                }
                if (!this.wrappedIterator.hasNext()) {
                    this.wrappedIterator.close();
                }
            }
        }
    }
}

