/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.ExtractorRegistry;
import org.semanticdesktop.aperture.extractor.FileExtractorFactory;

public class ExtractorRegistryImpl
implements ExtractorRegistry {
    private HashMap extractorFactories = new HashMap();
    private HashMap fileExtractorFactories = new HashMap();

    public void add(ExtractorFactory extractorFactory) {
        if (extractorFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String string : extractorFactory.getSupportedMimeTypes()) {
            HashSet<ExtractorFactory> hashSet = (HashSet<ExtractorFactory>)this.extractorFactories.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<ExtractorFactory>();
                this.extractorFactories.put(string, hashSet);
            }
            hashSet.add(extractorFactory);
        }
    }

    public void add(FileExtractorFactory fileExtractorFactory) {
        if (fileExtractorFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String string : fileExtractorFactory.getSupportedMimeTypes()) {
            HashSet<FileExtractorFactory> hashSet = (HashSet<FileExtractorFactory>)this.fileExtractorFactories.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<FileExtractorFactory>();
                this.fileExtractorFactories.put(string, hashSet);
            }
            hashSet.add(fileExtractorFactory);
        }
    }

    public void remove(ExtractorFactory extractorFactory) {
        for (String string : extractorFactory.getSupportedMimeTypes()) {
            Set set = (Set)this.extractorFactories.get(string);
            if (set == null) continue;
            set.remove(extractorFactory);
            if (!set.isEmpty()) continue;
            this.extractorFactories.remove(string);
        }
    }

    public void remove(FileExtractorFactory fileExtractorFactory) {
        for (String string : fileExtractorFactory.getSupportedMimeTypes()) {
            Set set = (Set)this.fileExtractorFactories.get(string);
            if (set == null) continue;
            set.remove(fileExtractorFactory);
            if (!set.isEmpty()) continue;
            this.fileExtractorFactories.remove(string);
        }
    }

    public Set get(String string) {
        return this.getExtractorFactories(string);
    }

    public Set getExtractorFactories(String string) {
        Set set = (Set)this.extractorFactories.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(set);
    }

    public Set getAll() {
        return this.getAllExtractorFactories();
    }

    public Set getAllExtractorFactories() {
        HashSet hashSet = new HashSet();
        for (Set set : this.extractorFactories.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public Set getAllFileExtractorFactories() {
        HashSet hashSet = new HashSet();
        for (Set set : this.fileExtractorFactories.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public Set getFileExtractorFactories(String string) {
        Set set = (Set)this.fileExtractorFactories.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(set);
    }
}

