/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.xml;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlExtractor
implements Extractor {
    private static final int BUFFER_SIZE = 8192;

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, 8192);
            }
            inputStream.mark(8192);
            FilterInputStream filterInputStream = new FilterInputStream(inputStream){

                public void close() {
                }
            };
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            XmlTextExtractor xmlTextExtractor = new XmlTextExtractor();
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(uRI.toString());
            inputSource.setByteStream(filterInputStream);
            try {
                sAXParser.parse(inputSource, (DefaultHandler)xmlTextExtractor);
            }
            catch (Exception exception) {
                if (!this.isFailingInclusionException(exception)) {
                    return;
                }
                try {
                    XMLReader xMLReader = sAXParser.getXMLReader();
                    xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    xmlTextExtractor.clear();
                    inputStream.reset();
                    sAXParser.parse(inputSource, (DefaultHandler)xmlTextExtractor);
                }
                catch (SAXException sAXException) {
                    Logger logger = LoggerFactory.getLogger(this.getClass());
                    logger.error("FileNotFoundException while parsing document " + uRI.toString(), (Throwable)exception);
                    logger.error("While trying to reparse the file without loading external DTDs following error occured", (Throwable)sAXException);
                }
            }
            String string2 = xmlTextExtractor.getText();
            if (!string2.equals("")) {
                rDFContainer.add(NIE.plainTextContent, string2);
                rDFContainer.add(RDF.type, (Node)NFO.PlainTextDocument);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExtractorException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ExtractorException(sAXException);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }

    private boolean isFailingInclusionException(Exception exception) {
        return exception instanceof FileNotFoundException || exception instanceof UnknownHostException;
    }

    private static class XmlTextExtractor
    extends DefaultHandler {
        private StringBuilder buffer = new StringBuilder(65536);

        private XmlTextExtractor() {
        }

        public String getText() {
            return this.buffer.toString().trim();
        }

        public void clear() {
            this.buffer.setLength(0);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getValue(i);
                if (string4 == null || string4.length() <= 0 || this.isGarbage(string4)) continue;
                this.buffer.append(string4);
                this.buffer.append(' ');
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
            this.buffer.append(' ');
        }

        private boolean isGarbage(String string) {
            return "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string);
        }
    }
}

