/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.semanticdesktop.aperture.security.trustmanager.standard.CertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentCertificateStore
implements CertificateStore {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private File certificatesFile;
    private KeyStore keyStore;
    private char[] password;

    public PersistentCertificateStore(File file, char[] cArray) {
        this.certificatesFile = file;
        this.password = cArray;
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
                    if (PersistentCertificateStore.this.keyStore == null) {
                        PersistentCertificateStore.this.keyStore = KeyStore.getInstance("JKS");
                        PersistentCertificateStore.this.keyStore.load(null, null);
                    }
                    if (PersistentCertificateStore.this.certificatesFile.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(PersistentCertificateStore.this.certificatesFile);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        PersistentCertificateStore.this.keyStore.load(bufferedInputStream, PersistentCertificateStore.this.password);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            this.logger.error("Unrecognized nested exception, ignoring", (Throwable)privilegedActionException);
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
                    FileOutputStream fileOutputStream = new FileOutputStream(PersistentCertificateStore.this.certificatesFile);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    PersistentCertificateStore.this.keyStore.store(bufferedOutputStream, PersistentCertificateStore.this.password);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            this.logger.error("Unrecognized nested exception, ignoring", (Throwable)privilegedActionException);
        }
    }

    public void add(Certificate certificate) throws KeyStoreException {
        if (!this.contains(certificate)) {
            Random random = new Random();
            String string = null;
            while (this.keyStore.getCertificate(string = "pcscert" + random.nextLong()) != null) {
            }
            this.keyStore.setCertificateEntry(string, certificate);
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        String string = this.keyStore.getCertificateAlias(certificate);
        if (string != null) {
            this.keyStore.deleteEntry(string);
        }
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        String string = this.keyStore.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            hashSet.add(this.keyStore.getCertificate(string));
        }
        return hashSet.iterator();
    }
}

