/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Query;
import javax.persistence.Table;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.SecureHash;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.property.PropertyType;

@Entity
@Table(name="MODE_SIMPLE_LARGE_VALUES")
@NamedQuery(name="LargeValueEntity.deleteAllUnused", query="delete LargeValueEntity lve where lve.hash not in (select values.hash from NodeEntity node join node.largeValues values)")
public class LargeValueEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MYSQL_DELETE_ALL_UNUSED_LARGE_VALUE_ENTITIES = "DELETE lv FROM MODE_SIMPLE_LARGE_VALUES AS lv LEFT OUTER JOIN ModeShape_LARGEVALUE_USAGES AS lvu ON lv.SHA1 = lvu.largeValues_SHA1 WHERE lvu.ID IS NULL";
    @Id
    @Column(name="SHA1", nullable=false, length=40)
    private String hash;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", nullable=false)
    private PropertyType type;
    @Column(name="LENGTH", nullable=false)
    private long length;
    @Column(name="COMPRESSED", nullable=true)
    private Boolean compressed;
    @Lob
    @Column(name="DATA", nullable=false, length=0x40000000)
    private byte[] data;

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isCompressed() {
        return this.compressed != null && this.compressed != false;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LargeValueEntity) {
            LargeValueEntity that = (LargeValueEntity)obj;
            if (this.getHash().equals(that.getHash())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Large " + this.type + " value (hash=" + this.getHash() + ",compressed=" + this.isCompressed() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteUnused(EntityManager manager, String dialect) {
        assert (manager != null);
        try {
            if (dialect != null && dialect.toLowerCase().indexOf("mysql") != -1) {
                Query delete = manager.createNativeQuery(MYSQL_DELETE_ALL_UNUSED_LARGE_VALUE_ENTITIES);
                delete.executeUpdate();
                boolean bl = true;
                return bl;
            }
            Query delete = manager.createNamedQuery("LargeValueEntity.deleteAllUnused");
            delete.executeUpdate();
            boolean bl = true;
            return bl;
        }
        finally {
            manager.flush();
        }
    }

    private static byte[] computeHash(byte[] value) {
        try {
            return SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    public static LargeValueEntity create(byte[] data, PropertyType type, boolean compressed) {
        String hashStr = StringUtil.getHexString((byte[])LargeValueEntity.computeHash(data));
        LargeValueEntity entity = new LargeValueEntity();
        entity.setData(data);
        entity.setType(type);
        entity.setCompressed(compressed);
        entity.setHash(hashStr);
        return entity;
    }
}

