/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;
import org.modeshape.jdbc.metadata.QueryResultRowIterator;

class QueryResultRow
implements Row {
    protected final QueryResultRowIterator iterator;
    protected final List<?> tuple;
    private String[] columnNames = null;

    protected QueryResultRow(QueryResultRowIterator iterator, List<?> tuple, String[] colNames) {
        this.iterator = iterator;
        this.tuple = tuple;
        this.columnNames = colNames;
    }

    public Node getNode() {
        throw new UnsupportedOperationException();
    }

    public Node getNode(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public String getPath(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public double getScore() {
        throw new UnsupportedOperationException();
    }

    public double getScore(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public Value getValue(String arg0) throws ItemNotFoundException {
        int pos = this.getColumnPosition(arg0);
        if (pos >= 0) {
            return this.createValue(this.tuple.get(pos));
        }
        throw new ItemNotFoundException("Item " + arg0 + " not found");
    }

    private int getColumnPosition(String colName) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!this.columnNames[i].equals(colName)) continue;
            return i;
        }
        return -1;
    }

    public Value[] getValues() throws RepositoryException {
        Value[] values = new Value[this.tuple.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.createValue(this.tuple.get(i));
        }
        return values;
    }

    private Value createValue(final Object value) {
        if (value == null) {
            return null;
        }
        Value rtnvalue = new Value(){
            final Object valueObject;
            {
                this.valueObject = value;
            }

            public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Boolean) {
                    return (Boolean)this.valueObject;
                }
                throw new ValueFormatException("Value not a Boolean");
            }

            public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Date) {
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)value);
                    return c;
                }
                throw new ValueFormatException("Value not instance of Date");
            }

            public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Double) {
                    return (Double)this.valueObject;
                }
                throw new ValueFormatException("Value not a Double");
            }

            public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Long) {
                    return (Long)this.valueObject;
                }
                throw new ValueFormatException("Value not a Long");
            }

            public Binary getBinary() throws RepositoryException {
                if (value instanceof Binary) {
                    return (Binary)this.valueObject;
                }
                if (value instanceof byte[]) {
                    final byte[] bytes = (byte[])value;
                    return new Binary(){

                        public void dispose() {
                        }

                        public long getSize() {
                            return bytes.length;
                        }

                        public InputStream getStream() {
                            return new ByteArrayInputStream(bytes);
                        }

                        public int read(byte[] b, long position) throws IOException {
                            if (this.getSize() <= position) {
                                return -1;
                            }
                            InputStream stream = null;
                            IOException error = null;
                            try {
                                long skipped;
                                stream = this.getStream();
                                for (long skip = position; skip > 0L; skip -= skipped) {
                                    skipped = stream.skip(skip);
                                    if (skipped > 0L) continue;
                                    int n = -1;
                                    return n;
                                }
                                int n = stream.read(b);
                                return n;
                            }
                            catch (IOException e) {
                                error = e;
                                throw e;
                            }
                            finally {
                                block19: {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (RuntimeException t) {
                                            if (error == null) {
                                                throw t;
                                            }
                                        }
                                        catch (IOException t) {
                                            if (error != null) break block19;
                                            throw t;
                                        }
                                    }
                                }
                            }
                        }
                    };
                }
                throw new ValueFormatException("Value not a Binary");
            }

            public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
                if (value instanceof BigDecimal) {
                    return (BigDecimal)this.valueObject;
                }
                throw new ValueFormatException("Value not a Decimal");
            }

            public InputStream getStream() throws IllegalStateException, RepositoryException {
                if (value instanceof Binary) {
                    return ((Binary)this.valueObject).getStream();
                }
                if (value instanceof InputStream) {
                    return (InputStream)this.valueObject;
                }
                throw new ValueFormatException("Value not an InputStream");
            }

            public String getString() throws IllegalStateException {
                if (value instanceof String) {
                    return (String)this.valueObject;
                }
                return this.valueObject.toString();
            }

            public int getType() {
                return 1;
            }
        };
        return rtnvalue;
    }
}

