/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.util.Base64;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.FileSystemBinary;

public class DiskNode
extends MapNode {
    private static final long serialVersionUID = 1L;
    private transient Set<String> largeValueKeys;

    public DiskNode(UUID uuid, Path.Segment name, UUID parent, Map<Name, Property> properties, List<UUID> children) {
        super(uuid, name, parent, properties, children);
        this.calculateLargeValueKeys();
    }

    public DiskNode(UUID uuid, Path.Segment name, UUID parent, Iterable<Property> properties, List<UUID> children) {
        super(uuid, name, parent, properties, children);
        this.calculateLargeValueKeys();
    }

    public DiskNode(UUID uuid) {
        super(uuid);
        this.calculateLargeValueKeys();
    }

    private DiskNode(UUID uuid, Path.Segment name, UUID parent, Map<Name, Property> properties, List<UUID> children, Set<String> largeValueKeys) {
        super(uuid, name, parent, properties, children);
        this.largeValueKeys = largeValueKeys;
    }

    private void calculateLargeValueKeys() {
        this.largeValueKeys = new HashSet<String>();
        try {
            for (Property property : this.getProperties().values()) {
                for (Object value : property) {
                    if (!(value instanceof FileSystemBinary)) continue;
                    this.largeValueKeys.add(Base64.encodeBytes((byte[])((Binary)value).getHash(), (int)16));
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        this.largeValueKeys = Collections.unmodifiableSet(this.largeValueKeys);
    }

    Set<String> largeValueHashesInUse() {
        return this.largeValueKeys;
    }

    public DiskNode freeze() {
        if (!this.hasChanges()) {
            return this;
        }
        return new DiskNode(this.getUuid(), this.getName(), this.getParent(), this.changes.getUnmodifiableProperties(), this.changes.getUnmodifiableChildren(), this.largeValueKeys);
    }

    public DiskNode clone() {
        return new DiskNode(this.getUuid(), this.getName(), this.getParent(), this.getProperties(), (List<UUID>)this.getChildren());
    }
}

