/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.cnd;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.modeshape.cnd.CndImporter;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.cnd.CndSequencerI18n;

public class CndSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        OutputDestination destination = new OutputDestination(output, context);
        Path root = context.getValueFactories().getPathFactory().createRootPath();
        CndImporter importer = new CndImporter((Destination)destination, root);
        Path inputPath = context.getInputPath();
        if (inputPath.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
            inputPath = inputPath.getParent();
        }
        String resourceName = inputPath.getLastSegment().getString(context.getNamespaceRegistry());
        try {
            importer.importFrom(stream, context.getProblems(), resourceName);
        }
        catch (IOException e) {
            context.getProblems().addError((Throwable)e, CndSequencerI18n.errorSequencingCndContent, new Object[]{e.getLocalizedMessage()});
        }
    }

    protected class OutputDestination
    implements Destination {
        private final SequencerOutput output;
        private final StreamSequencerContext context;
        private final Map<Path, AtomicInteger> paths = new HashMap<Path, AtomicInteger>();
        private final PathFactory pathFactory;

        protected OutputDestination(SequencerOutput output, StreamSequencerContext context) {
            this.output = output;
            this.context = context;
            this.pathFactory = context.getValueFactories().getPathFactory();
        }

        public ExecutionContext getExecutionContext() {
            return this.context;
        }

        protected Path checkPath(Path path) {
            AtomicInteger count = this.paths.get(path = path.relativeToRoot());
            if (count == null) {
                count = new AtomicInteger(1);
                this.paths.put(path, count);
                return path;
            }
            int snsIndex = count.incrementAndGet();
            Path parent = path.getParent();
            if (parent == null) {
                return path;
            }
            return this.pathFactory.create(parent, path.getLastSegment().getName(), snsIndex);
        }

        public void create(Path path, Iterable<Property> properties) {
            path = this.checkPath(path);
            for (Property property : properties) {
                this.output.setProperty(path, property.getName(), property.getValuesAsArray());
            }
        }

        public void create(Path path, Property firstProperty, Property ... additionalProperties) {
            path = this.checkPath(path);
            this.output.setProperty(path, firstProperty.getName(), new Object[]{firstProperty.getValues()});
            for (Property property : additionalProperties) {
                this.output.setProperty(path, property.getName(), property.getValuesAsArray());
            }
        }

        public void create(NodeConflictBehavior behavior, Path path, Property firstProperty, Property ... additionalProperties) {
            this.create(path, firstProperty, additionalProperties);
        }

        public void setProperties(Path path, Property ... properties) {
            path = this.checkPath(path);
            for (Property property : properties) {
                this.output.setProperty(path, property.getName(), property.getValuesAsArray());
            }
        }

        public void setProperties(Path path, Iterable<Property> properties) {
            path = this.checkPath(path);
            for (Property property : properties) {
                this.output.setProperty(path, property.getName(), property.getValuesAsArray());
            }
        }

        public void submit() {
        }
    }
}

