/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class IdsQuery
extends Query {
    private static final long serialVersionUID = 1L;
    protected final Set<String> uuids;
    protected final FieldSelector fieldSelector;
    protected final String fieldName;

    public IdsQuery(String fieldName, Set<String> ids) {
        this.fieldName = fieldName;
        this.uuids = ids;
        assert (this.fieldName != null);
        assert (this.uuids != null);
        this.fieldSelector = new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                return fieldName.equals(fieldName) ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };
    }

    protected boolean includeDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String valueString = doc.get(this.fieldName);
        return valueString != null && this.uuids.contains(valueString);
    }

    public Weight createWeight(Searcher searcher) {
        return new IdSetWeight();
    }

    public String toString(String field) {
        return this.fieldName + " IN UUIDs";
    }

    protected class IdScorer
    extends Scorer {
        private int docId;
        private final int pastMaxDocId;
        private final IndexReader reader;

        protected IdScorer(IndexReader reader, Weight weight) {
            super(weight);
            this.docId = -1;
            this.reader = reader;
            assert (this.reader != null);
            this.pastMaxDocId = this.reader.maxDoc();
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            do {
                ++this.docId;
                if (this.docId != this.pastMaxDocId) continue;
                return Integer.MAX_VALUE;
            } while (this.reader.isDeleted(this.docId) || !IdsQuery.this.includeDocument(this.reader, this.docId));
            return this.docId;
        }

        public int advance(int target) throws IOException {
            int doc;
            if (target == Integer.MAX_VALUE) {
                return target;
            }
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public float score() {
            return 1.0f;
        }
    }

    protected class IdSetWeight
    extends Weight {
        private static final long serialVersionUID = 1L;

        protected IdSetWeight() {
        }

        public Query getQuery() {
            return IdsQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            return new IdScorer(reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) {
            return new Explanation(this.getValue(), this.getQuery().toString());
        }
    }
}

