/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.WebdavException;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.Logger;
import org.modeshape.web.jcr.RepositoryFactory;
import org.modeshape.web.jcr.webdav.ContentMapper;
import org.modeshape.web.jcr.webdav.RequestResolver;
import org.modeshape.web.jcr.webdav.ResolvedRequest;
import org.modeshape.web.jcr.webdav.WebdavI18n;

public class ModeShapeWebdavStore
implements IWebdavStore {
    private static final ThreadLocal<HttpServletRequest> THREAD_LOCAL_REQUEST = new ThreadLocal();
    private static final Map<String, byte[]> OSX_DOUBLE_DATA = Collections.synchronizedMap(new WeakHashMap());
    private static final String CREATED_PROP_NAME = "jcr:created";
    private final RequestResolver requestResolver;
    private final ContentMapper contentMapper;
    private final Logger logger = Logger.getLogger(this.getClass());

    public ModeShapeWebdavStore(RequestResolver requestResolver, ContentMapper contentMapper) {
        this.requestResolver = requestResolver;
        this.contentMapper = contentMapper;
    }

    static final void setRequest(HttpServletRequest request) {
        THREAD_LOCAL_REQUEST.set(request);
    }

    public ITransaction begin(Principal principal) {
        return new JcrSessionTransaction(principal);
    }

    public void commit(ITransaction transaction) {
        CheckArg.isNotNull((Object)transaction, (String)"transaction");
        assert (transaction instanceof JcrSessionTransaction);
        ((JcrSessionTransaction)transaction).commit();
    }

    public void rollback(ITransaction transaction) {
    }

    public void checkAuthentication(ITransaction transaction) {
    }

    public void createFolder(ITransaction transaction, String folderUri) {
        int ind = folderUri.lastIndexOf(47);
        String parentUri = folderUri.substring(0, ind + 1);
        String resourceName = folderUri.substring(ind + 1);
        try {
            this.logger.debug("WebDAV create folder at: " + parentUri, new Object[0]);
            ResolvedRequest resolvedParent = this.resolveRequest(transaction, parentUri);
            this.logger.debug("WebDAV create folder at: " + resolvedParent, new Object[0]);
            if (resolvedParent.getPath() == null) {
                if (resolvedParent.getRepositoryName() == null) {
                    throw new WebdavException(WebdavI18n.cannotCreateRepository.text(new Object[]{resourceName}));
                }
                if (resolvedParent.getWorkspaceName() != null) {
                    resolvedParent = resolvedParent.withPath("/");
                } else {
                    I18n msg = WebdavI18n.cannotCreateWorkspaceInRepository;
                    throw new WebdavException(msg.text(new Object[]{resourceName, resolvedParent.getRepositoryName()}));
                }
            }
            Node parentNode = this.nodeFor(transaction, resolvedParent);
            this.contentMapper.createFolder(parentNode, resourceName);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public void createResource(ITransaction transaction, String resourceUri) {
        if (resourceUri.endsWith(".DS_Store")) {
            return;
        }
        int ind = resourceUri.lastIndexOf(47);
        String parentUri = resourceUri.substring(0, ind + 1);
        String resourceName = resourceUri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(resourceUri, null);
            return;
        }
        try {
            ResolvedRequest resolvedParent = this.resolveRequest(transaction, parentUri);
            if (resolvedParent.getPath() == null) {
                if (resolvedParent.getRepositoryName() == null) {
                    throw new WebdavException(WebdavI18n.cannotCreateRepository.text(new Object[]{resourceName}));
                }
                if (resolvedParent.getWorkspaceName() != null) {
                    resolvedParent = resolvedParent.withPath("/");
                } else {
                    I18n msg = WebdavI18n.cannotCreateWorkspaceInRepository;
                    throw new WebdavException(msg.text(new Object[]{resourceName, resolvedParent.getRepositoryName()}));
                }
            }
            Node parentNode = this.nodeFor(transaction, resolvedParent);
            this.contentMapper.createFile(parentNode, resourceName);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public String[] getChildrenNames(ITransaction transaction, String folderUri) {
        try {
            this.logger.trace("WebDAV getChildrenNames(txn,\"" + folderUri + "\")", new Object[0]);
            ResolvedRequest resolved = this.resolveRequest(transaction, folderUri);
            this.logger.trace("WebDAV -> resolves to: " + resolved, new Object[0]);
            if (resolved.getPath() == null) {
                return this.childrenFor(transaction, resolved);
            }
            Node node = this.nodeFor(transaction, resolved);
            this.logger.trace("WebDAV -> node: " + node, new Object[0]);
            if (!this.isFolder(node)) {
                return null;
            }
            List<String> children = ModeShapeWebdavStore.namesOfChildren(node);
            this.logger.trace("WebDAV -> children: " + children, new Object[0]);
            return children.toArray(new String[children.size()]);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    protected static List<String> namesOfChildren(Node node) throws RepositoryException {
        LinkedList<String> children = new LinkedList<String>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            String name = child.getIndex() == 1 ? child.getName() : child.getName() + "[" + child.getIndex() + "]";
            children.add(name);
        }
        return children;
    }

    public InputStream getResourceContent(ITransaction transaction, String resourceUri) {
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, resourceUri);
            if (resolved.getPath() == null) {
                return null;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (!this.isFile(node)) {
                return null;
            }
            return this.contentMapper.getResourceContent(node);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public long getResourceLength(ITransaction transaction, String uri) {
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, uri);
            if (resolved.getPath() == null) {
                return -1L;
            }
            Node node = this.nodeFor(transaction, resolved);
            return this.contentMapper.getResourceLength(node);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        if (uri.length() == 0) {
            uri = "/";
        }
        StoredObject ob = new StoredObject();
        try {
            this.logger.trace("WebDAV getStoredObject at \"" + uri + "\"", new Object[0]);
            ResolvedRequest resolved = this.resolveRequest(transaction, uri);
            this.logger.debug("WebDAV getStoredObject at \"" + uri + "\" resolved to \"" + resolved + "\"", new Object[0]);
            if (resolved.getPath() == null) {
                if (this.repositoryAndWorkspaceExist(transaction, resolved)) {
                    ob.setFolder(true);
                    Date now = new Date();
                    ob.setCreationDate(now);
                    ob.setLastModified(now);
                    ob.setResourceLength(0L);
                    return ob;
                }
                return null;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (this.isFolder(node)) {
                ob.setFolder(true);
                Date createDate = null;
                createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(new Date());
                ob.setResourceLength(0L);
            } else if (this.isFile(node)) {
                ob.setFolder(false);
                Date createDate = null;
                createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(this.contentMapper.getLastModified(node));
                ob.setResourceLength(this.contentMapper.getResourceLength(node));
            } else {
                ob.setNullResource(true);
            }
        }
        catch (PathNotFoundException pnfe) {
            return null;
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
        return ob;
    }

    public void removeObject(ITransaction transaction, String uri) {
        int ind = uri.lastIndexOf(47);
        String resourceName = uri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(uri, null);
            return;
        }
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, uri);
            if (resolved.getPath() != null) {
                Node node = this.nodeFor(transaction, resolved);
                node.remove();
            }
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public long setResourceContent(ITransaction transaction, String resourceUri, InputStream content, String contentType, String characterEncoding) {
        if (resourceUri.endsWith(".DS_Store")) {
            return 0L;
        }
        int ind = resourceUri.lastIndexOf(47);
        String resourceName = resourceUri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            try {
                OSX_DOUBLE_DATA.put(resourceUri, IoUtil.readBytes((InputStream)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 0L;
        }
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, resourceUri);
            if (resolved.getPath() == null) {
                return -1L;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (!this.isFile(node)) {
                return -1L;
            }
            return this.contentMapper.setContent(node, resourceName, content, contentType, characterEncoding);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RuntimeException t) {
            throw t;
        }
    }

    private boolean isFile(Node node) throws RepositoryException {
        return this.contentMapper.isFile(node);
    }

    private boolean isFolder(Node node) throws RepositoryException {
        return this.contentMapper.isFolder(node);
    }

    private final ResolvedRequest resolveRequest(ITransaction transaction, String uri) throws WebdavException {
        HttpServletRequest request = THREAD_LOCAL_REQUEST.get();
        return this.requestResolver.resolve(request, uri);
    }

    private final Node nodeFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).nodeFor(request);
    }

    private final boolean repositoryAndWorkspaceExist(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).repositoryAndWorkspaceExist(request);
    }

    private final String[] childrenFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).childrenFor(request);
    }

    protected final RequestResolver requestResolver() {
        return this.requestResolver;
    }

    protected static final class SessionKey {
        protected final String repositoryName;
        protected final String workspaceName;

        protected SessionKey(String repositoryName, String workspaceName) {
            this.repositoryName = repositoryName;
            this.workspaceName = workspaceName;
            assert (this.repositoryName != null);
            assert (this.workspaceName != null);
        }

        public int hashCode() {
            return this.repositoryName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SessionKey) {
                SessionKey that = (SessionKey)obj;
                return this.repositoryName.equals(that.repositoryName) && this.workspaceName.equals(that.workspaceName);
            }
            return false;
        }

        public String toString() {
            return this.repositoryName + "/" + this.workspaceName;
        }
    }

    class JcrSessionTransaction
    implements ITransaction {
        private final Map<SessionKey, Session> sessions = new HashMap<SessionKey, Session>();
        private final Principal principal;

        JcrSessionTransaction(Principal principal) {
            this.principal = principal;
        }

        protected boolean owns(Session session) {
            return this.sessions.containsValue(session);
        }

        Session session(ResolvedRequest request) throws RepositoryException {
            String repositoryName = request.getRepositoryName();
            String workspaceName = request.getWorkspaceName();
            assert (repositoryName != null);
            assert (workspaceName != null);
            SessionKey key = new SessionKey(repositoryName, workspaceName);
            Session result = this.sessions.get(key);
            if (result == null) {
                result = RepositoryFactory.getSession((HttpServletRequest)request.getRequest(), (String)repositoryName, (String)workspaceName);
                this.sessions.put(key, result);
            }
            return result;
        }

        Node nodeFor(ResolvedRequest request) throws RepositoryException {
            Session session = this.session(request);
            Item item = session.getItem(request.getPath());
            if (item instanceof Property) {
                throw new WebdavException();
            }
            return (Node)item;
        }

        boolean repositoryAndWorkspaceExist(ResolvedRequest request) throws RepositoryException {
            assert (request != null);
            if (request.getRepositoryName() != null) {
                if (request.getWorkspaceName() != null) {
                    try {
                        this.session(request);
                        return true;
                    }
                    catch (NoSuchWorkspaceException e) {
                        return false;
                    }
                }
                return RepositoryFactory.getJcrRepositoryNames().contains(request.getRepositoryName());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String[] childrenFor(ResolvedRequest request) throws RepositoryException {
            Iterator<Map.Entry<SessionKey, Session>> i$;
            String repositoryName;
            assert (request != null);
            List<String> names = null;
            if (request.getRepositoryName() != null) {
                if (request.getWorkspaceName() != null) {
                    try {
                        Session session = this.session(request);
                        names = ModeShapeWebdavStore.namesOfChildren(session.getRootNode());
                    }
                    catch (NoSuchWorkspaceException e) {
                        return null;
                    }
                }
                repositoryName = request.getRepositoryName();
                i$ = this.sessions.entrySet().iterator();
            } else {
                names = RepositoryFactory.getJcrRepositoryNames();
                if (names == null) {
                    return null;
                }
                String[] stringArray = names.toArray(new String[names.size()]);
                return stringArray;
            }
            while (i$.hasNext()) {
                Map.Entry<SessionKey, Session> entry = i$.next();
                SessionKey key = entry.getKey();
                if (!repositoryName.equals(key.repositoryName)) continue;
                Session session = entry.getValue();
                try {
                    return session.getWorkspace().getAccessibleWorkspaceNames();
                }
                catch (RepositoryException e) {
                }
            }
            Session session = null;
            try {
                session = RepositoryFactory.getSession((HttpServletRequest)request.getRequest(), (String)repositoryName, null);
                String[] stringArray = session.getWorkspace().getAccessibleWorkspaceNames();
                return stringArray;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        void commit() {
            try {
                for (Session session : this.sessions.values()) {
                    session.save();
                }
            }
            catch (RepositoryException re) {
                throw new WebdavException((Throwable)re);
            }
            finally {
                for (Session session : this.sessions.values()) {
                    try {
                        session.logout();
                    }
                    catch (Throwable t) {}
                }
                this.sessions.clear();
            }
        }
    }
}

