/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Readable;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPathSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public interface Path
extends Comparable<Path>,
Iterable<Segment>,
Serializable,
Readable {
    public static final TextEncoder NO_OP_ENCODER = new NoOpEncoder();
    public static final TextEncoder JSR283_ENCODER = new Jsr283Encoder();
    public static final TextEncoder URL_ENCODER = new UrlEncoder().setSlashEncoded(true);
    public static final TextDecoder NO_OP_DECODER = new NoOpEncoder();
    public static final TextDecoder JSR283_DECODER = new Jsr283Encoder();
    public static final TextDecoder URL_DECODER = new UrlEncoder().setSlashEncoded(true);
    public static final TextEncoder DEFAULT_ENCODER = JSR283_ENCODER;
    public static final TextDecoder DEFAULT_DECODER = JSR283_DECODER;
    public static final char DELIMITER = '/';
    public static final char IDENTIFIER_LEADING_TERMINAL = '[';
    public static final char IDENTIFIER_TRAILING_TERMINAL = ']';
    public static final String DELIMITER_STR = new String(new char[]{'/'});
    public static final String PARENT = "..";
    public static final String SELF = ".";
    public static final int DEFAULT_INDEX = 1;
    public static final Name SELF_NAME = new BasicName(null, ".");
    public static final Name PARENT_NAME = new BasicName(null, "..");
    public static final Segment SELF_SEGMENT = new BasicPathSegment(SELF_NAME);
    public static final Segment PARENT_SEGMENT = new BasicPathSegment(PARENT_NAME);

    public int size();

    public boolean isRoot();

    public boolean isIdentifier();

    public boolean isSameAs(Path var1);

    public boolean isAtOrAbove(Path var1);

    public boolean isAtOrBelow(Path var1);

    public boolean isAncestorOf(Path var1);

    public boolean isDecendantOf(Path var1);

    public boolean isAbsolute();

    public boolean isNormalized();

    public Path getNormalizedPath();

    public Path getCanonicalPath();

    public Path relativeToRoot();

    public Path relativeTo(Path var1);

    public Path resolve(Path var1);

    public Path resolveAgainst(Path var1);

    public Path getParent();

    public Path getAncestor(int var1);

    public boolean hasSameAncestor(Path var1);

    public Path getCommonAncestor(Path var1);

    public Segment getLastSegment();

    public boolean endsWith(Name var1);

    public boolean endsWith(Name var1, int var2);

    public Segment getSegment(int var1);

    public Path subpath(int var1);

    public Path subpath(int var1, int var2);

    @Override
    public Iterator<Segment> iterator();

    public Iterator<Path> pathsFromRoot();

    public Segment[] getSegmentsArray();

    public List<Segment> getSegmentsList();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static interface Segment
    extends Cloneable,
    Comparable<Segment>,
    Serializable,
    Readable {
        public Name getName();

        public int getIndex();

        public boolean hasIndex();

        public boolean isSelfReference();

        public boolean isParentReference();

        public boolean isIdentifier();

        public String getUnencodedString();
    }
}

