/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.datasource.config.DomainBoundaries;
import org.semanticdesktop.aperture.datasource.config.RegExpPattern;
import org.semanticdesktop.aperture.datasource.config.SubstringCondition;
import org.semanticdesktop.aperture.datasource.config.SubstringPattern;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtil {
    private static final URI IcalDataSource = new URIImpl("http://aperture.semanticdesktop.org/ontology/2007/08/12/icalds#IcalDataSource");
    private static final URI ical_rootUrl = new URIImpl("http://aperture.semanticdesktop.org/ontology/2007/08/12/icalds#rootUrl");

    private ConfigurationUtil() {
    }

    public static void setName(String string, RDFContainer rDFContainer) {
        rDFContainer.put(DATASOURCE.dataSourceName, string);
    }

    public static String getName(RDFContainer rDFContainer) {
        return rDFContainer.getString(DATASOURCE.dataSourceName);
    }

    public static void setUsername(String string, RDFContainer rDFContainer) {
        rDFContainer.put(DATASOURCE.username, string);
    }

    public static String getUsername(RDFContainer rDFContainer) {
        return rDFContainer.getString(DATASOURCE.username);
    }

    public static void setPassword(String string, RDFContainer rDFContainer) {
        rDFContainer.put(DATASOURCE.password, string);
    }

    public static String getPassword(RDFContainer rDFContainer) {
        return rDFContainer.getString(DATASOURCE.password);
    }

    public static void setDomainBoundaries(DomainBoundaries domainBoundaries, RDFContainer rDFContainer) {
        URI uRI = rDFContainer.getDescribedUri();
        Model model = rDFContainer.getModel();
        try {
            ConfigurationUtil.deletePatternStatements(uRI, DATASOURCE.includePattern, model);
            ConfigurationUtil.deletePatternStatements(uRI, DATASOURCE.excludePattern, model);
            if (domainBoundaries != null) {
                ConfigurationUtil.addPatternStatements(uRI, domainBoundaries.getIncludePatterns(), DATASOURCE.includePattern, model);
                ConfigurationUtil.addPatternStatements(uRI, domainBoundaries.getExcludePatterns(), DATASOURCE.excludePattern, model);
            }
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePatternStatements(URI uRI, URI uRI2, Model model) throws ModelException {
        ClosableIterator closableIterator = null;
        try {
            LinkedList<Statement> linkedList = new LinkedList<Statement>();
            closableIterator = model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)uRI2, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Node node = statement.getObject();
                if (!(node instanceof Resource)) continue;
                Resource resource = (Resource)node;
                List<Statement> list = ConfigurationUtil.findStatements(resource, RDF.type, model);
                List<Statement> list2 = ConfigurationUtil.findStatements(resource, RDF.value, model);
                List<Statement> list3 = ConfigurationUtil.findStatements(resource, DATASOURCE.condition, model);
                if (list.size() <= 0 || list2.size() <= 0) continue;
                linkedList.add(statement);
                linkedList.addAll(list);
                linkedList.addAll(list2);
                linkedList.addAll(list3);
            }
            model.removeAll(linkedList.iterator());
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Statement> findStatements(Resource resource, URI uRI, Model model) throws ModelException {
        LinkedList<Statement> linkedList = new LinkedList<Statement>();
        ClosableIterator closableIterator = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                linkedList.add((Statement)closableIterator.next());
            }
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return linkedList;
    }

    private static void addPatternStatements(URI uRI, List list, URI uRI2, Model model) throws ModelException {
        for (UrlPattern urlPattern : list) {
            BlankNode blankNode = model.createBlankNode();
            model.addStatement(ModelUtil.createStatement(model, (Resource)uRI, uRI2, (Node)blankNode));
            Collection<Statement> collection = urlPattern.getStatements(model, (Resource)blankNode);
            model.addAll(collection.iterator());
        }
    }

    public static DomainBoundaries getDomainBoundaries(RDFContainer rDFContainer) {
        URI uRI = rDFContainer.getDescribedUri();
        Model model = rDFContainer.getModel();
        List<UrlPattern> list = ConfigurationUtil.getPatterns(uRI, DATASOURCE.includePattern, model);
        List<UrlPattern> list2 = ConfigurationUtil.getPatterns(uRI, DATASOURCE.excludePattern, model);
        return new DomainBoundaries(list, list2);
    }

    private static List<UrlPattern> getPatterns(URI uRI, URI uRI2, Model model) {
        ClosableIterator closableIterator = null;
        ArrayList<UrlPattern> arrayList = new ArrayList<UrlPattern>();
        try {
            closableIterator = model.findStatements((ResourceOrVariable)uRI, (UriOrVariable)uRI2, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                Node node;
                SubstringCondition substringCondition;
                Statement statement = (Statement)closableIterator.next();
                Node node2 = statement.getObject();
                if (!(node2 instanceof Resource)) continue;
                Resource resource = (Resource)node2;
                Node node3 = ConfigurationUtil.getSingleValue(resource, RDF.type, model);
                Node node4 = ConfigurationUtil.getSingleValue(resource, RDF.value, model);
                if (!(node3 instanceof URI) || !(node4 instanceof Literal)) continue;
                String string = ((Literal)node4).getValue();
                if (DATASOURCE.RegExpPattern.equals(node3)) {
                    arrayList.add(new RegExpPattern(string));
                    continue;
                }
                if (!DATASOURCE.SubstringPattern.equals(node3) || (substringCondition = ConfigurationUtil.resolveCondition(node = ConfigurationUtil.getSingleValue(resource, DATASOURCE.condition, model))) == null) continue;
                arrayList.add(new SubstringPattern(string, substringCondition));
            }
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getSingleValue(Resource resource, URI uRI, Model model) throws ModelException {
        ClosableIterator closableIterator = null;
        Node node = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)resource, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            if (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                node = statement.getObject();
            }
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        return node;
    }

    public static SubstringCondition resolveCondition(Node node) {
        String string = node.toString();
        if (DATASOURCE.STARTS_WITH.toString().equals(string)) {
            return new SubstringCondition.StartsWith();
        }
        if (DATASOURCE.ENDS_WITH.toString().equals(string)) {
            return new SubstringCondition.EndsWith();
        }
        if (DATASOURCE.CONTAINS.toString().equals(string)) {
            return new SubstringCondition.Contains();
        }
        if (DATASOURCE.DOES_NOT_CONTAIN.toString().equals(string)) {
            return new SubstringCondition.DoesNotContain();
        }
        return null;
    }
}

