/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;

public class DomainBoundaries {
    private ArrayList includePatterns;
    private ArrayList excludePatterns;

    public DomainBoundaries() {
        this(new ArrayList(1), new ArrayList(1));
    }

    public DomainBoundaries(List list, List list2) {
        this.includePatterns = new ArrayList(list);
        this.excludePatterns = new ArrayList(list2);
    }

    public void addIncludePattern(UrlPattern urlPattern) {
        this.includePatterns.add(urlPattern);
    }

    public boolean removeIncludePattern(UrlPattern urlPattern) {
        return this.includePatterns.remove(urlPattern);
    }

    public void removeAllIncludePatterns() {
        this.includePatterns.clear();
    }

    public List getIncludePatterns() {
        return Collections.unmodifiableList(this.includePatterns);
    }

    public void setIncludePatterns(List list) {
        this.includePatterns = new ArrayList(list);
    }

    public void addExcludePattern(UrlPattern urlPattern) {
        this.excludePatterns.add(urlPattern);
    }

    public boolean removeExcludePattern(UrlPattern urlPattern) {
        return this.excludePatterns.remove(urlPattern);
    }

    public void removeAllExcludePatterns() {
        this.excludePatterns.clear();
    }

    public List getExcludePatterns() {
        return Collections.unmodifiableList(this.excludePatterns);
    }

    public void setExcludePatterns(List list) {
        this.excludePatterns = new ArrayList(list);
    }

    public void removeAllPatterns() {
        this.removeAllIncludePatterns();
        this.removeAllExcludePatterns();
    }

    public boolean inDomain(String string) {
        UrlPattern urlPattern;
        int n;
        boolean bl = false;
        int n2 = this.includePatterns.size();
        if (n2 == 0) {
            bl = true;
        } else {
            for (n = 0; n < n2; ++n) {
                urlPattern = (UrlPattern)this.includePatterns.get(n);
                if (!urlPattern.matches(string)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            n = this.excludePatterns.size();
            for (int i = 0; i < n; ++i) {
                urlPattern = (UrlPattern)this.excludePatterns.get(i);
                if (!urlPattern.matches(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

