/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collection;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.datasource.config.SubstringCondition;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringPattern
extends UrlPattern {
    private String substring;
    private SubstringCondition condition;

    public SubstringPattern(String string, SubstringCondition substringCondition) {
        this.substring = string;
        this.condition = substringCondition;
    }

    public String getSubstring() {
        return this.substring;
    }

    public void setSubstring(String string) {
        this.substring = string;
    }

    public SubstringCondition getCondition() {
        return this.condition;
    }

    public void setCondition(SubstringCondition substringCondition) {
        this.condition = substringCondition;
    }

    @Override
    public boolean matches(String string) {
        return this.condition.test(string, this.substring);
    }

    @Override
    public Collection<Statement> getStatements(Model model, Resource resource) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        arrayList.add(ModelUtil.createStatement(model, resource, RDF.type, (Node)DATASOURCE.SubstringPattern));
        try {
            arrayList.add(ModelUtil.createStatement(model, resource, RDF.value, (Node)ModelUtil.createLiteral(model, this.substring, XSD._string)));
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
        arrayList.add(ModelUtil.createStatement(model, resource, DATASOURCE.condition, this.condition.toNode()));
        return arrayList;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof SubstringPattern) {
            SubstringPattern substringPattern = (SubstringPattern)object;
            bl = this.getSubstring().equals(substringPattern.getSubstring()) && this.getCondition().equals(substringPattern.getCondition());
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

