/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.imap;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.config.DomainBoundableDataSource;
import org.semanticdesktop.aperture.datasource.imap.IMAPDS;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapDataSource
extends DomainBoundableDataSource {
    @Override
    public URI getType() {
        return IMAPDS.ImapDataSource;
    }

    public String getHostname() {
        return this.getConfiguration().getString(IMAPDS.hostname);
    }

    public void setHostname(String string) {
        if (string == null) {
            this.getConfiguration().remove(IMAPDS.hostname);
        } else {
            this.getConfiguration().put(IMAPDS.hostname, string);
        }
    }

    public Integer getPort() {
        return this.getConfiguration().getInteger(IMAPDS.port);
    }

    public void setPort(Integer n) {
        if (n == null) {
            this.getConfiguration().remove(IMAPDS.port);
        } else {
            this.getConfiguration().put(IMAPDS.port, n);
        }
    }

    public String getUsername() {
        return this.getConfiguration().getString(DATASOURCE.username);
    }

    public void setUsername(String string) {
        if (string == null) {
            this.getConfiguration().remove(DATASOURCE.username);
        } else {
            this.getConfiguration().put(DATASOURCE.username, string);
        }
    }

    public String getPassword() {
        return this.getConfiguration().getString(DATASOURCE.password);
    }

    public void setPassword(String string) {
        if (string == null) {
            this.getConfiguration().remove(DATASOURCE.password);
        } else {
            this.getConfiguration().put(DATASOURCE.password, string);
        }
    }

    public Collection<String> getAllBasepaths() {
        Collection collection = this.getConfiguration().getAll(IMAPDS.basepath);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Node node : collection) {
            String string = (String)ModelUtil.convertNode(node, String.class);
            if (string == null) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public void setBasepath(String string) {
        if (string == null) {
            this.getConfiguration().remove(IMAPDS.basepath);
        } else {
            this.getConfiguration().put(IMAPDS.basepath, string);
        }
    }

    public void setAllBasepaths(List<String> list) {
        if (list == null) {
            ModelUtil.removeAllPropertyValues(this.getConfiguration().getModel(), (Resource)this.getConfiguration().getDescribedUri(), IMAPDS.basepath);
        } else {
            ModelUtil.removeAllPropertyValues(this.getConfiguration().getModel(), (Resource)this.getConfiguration().getDescribedUri(), IMAPDS.basepath);
            for (String string : list) {
                this.getConfiguration().add(IMAPDS.basepath, string);
            }
        }
    }

    public Boolean getIncludeInbox() {
        return this.getConfiguration().getBoolean(IMAPDS.includeInbox);
    }

    public void setIncludeInbox(Boolean bl) {
        if (bl == null) {
            this.getConfiguration().remove(IMAPDS.includeInbox);
        } else {
            this.getConfiguration().put(IMAPDS.includeInbox, bl);
        }
    }

    public Long getMaximumSize() {
        return this.getConfiguration().getLong(IMAPDS.maximumSize);
    }

    public void setMaximumSize(Long l) {
        if (l == null) {
            this.getConfiguration().remove(IMAPDS.maximumSize);
        } else {
            this.getConfiguration().put(IMAPDS.maximumSize, l);
        }
    }

    public Integer getMaximumDepth() {
        return this.getConfiguration().getInteger(IMAPDS.maximumDepth);
    }

    public void setMaximumDepth(Integer n) {
        if (n == null) {
            this.getConfiguration().remove(IMAPDS.maximumDepth);
        } else {
            this.getConfiguration().put(IMAPDS.maximumDepth, n);
        }
    }

    public ConnectionSecurity getConnectionSecurity() {
        return ConnectionSecurity.fromUri(this.getConfiguration().getURI(IMAPDS.connectionSecurity));
    }

    public void setConnectionSecurity(ConnectionSecurity connectionSecurity) {
        if (connectionSecurity == null) {
            this.getConfiguration().remove(IMAPDS.connectionSecurity);
        } else {
            this.getConfiguration().put(IMAPDS.connectionSecurity, (Node)connectionSecurity.toUri());
        }
    }

    public String getSslFileName() {
        return this.getConfiguration().getString(IMAPDS.sslFileName);
    }

    public void setSslFileName(String string) {
        if (string == null) {
            this.getConfiguration().remove(IMAPDS.sslFileName);
        } else {
            this.getConfiguration().put(IMAPDS.sslFileName, string);
        }
    }

    public String getSslFilePassword() {
        return this.getConfiguration().getString(IMAPDS.sslFilePassword);
    }

    public void setSslFilePassword(String string) {
        if (string == null) {
            this.getConfiguration().remove(IMAPDS.sslFilePassword);
        } else {
            this.getConfiguration().put(IMAPDS.sslFilePassword, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionSecurity {
        PLAIN,
        SSL,
        SSL_NO_CERT;


        public static ConnectionSecurity fromUri(URI uRI) {
            if (uRI == null) {
                return null;
            }
            if (uRI.equals(IMAPDS.PLAIN)) {
                return PLAIN;
            }
            if (uRI.equals(IMAPDS.SSL)) {
                return SSL;
            }
            if (uRI.equals(IMAPDS.SSL_NO_CERT)) {
                return SSL_NO_CERT;
            }
            return null;
        }

        public URI toUri() {
            if (this.equals((Object)PLAIN)) {
                return IMAPDS.PLAIN;
            }
            if (this.equals((Object)SSL)) {
                return IMAPDS.SSL;
            }
            if (this.equals((Object)SSL_NO_CERT)) {
                return IMAPDS.SSL_NO_CERT;
            }
            return null;
        }
    }
}

