/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.jpg;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NEXIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpgHeaderExtractor {
    private Metadata metadata = null;
    private Directory exifDirectory = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private URI id = null;
    private RDFContainer result = null;
    private Directory iptcDirectory;
    private Directory gpsDirectory;
    private NumberFormat degreesFormat;

    public JpgHeaderExtractor(URI uRI, InputStream inputStream, RDFContainer rDFContainer) {
        this.id = uRI;
        this.result = rDFContainer;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        this.degreesFormat = new DecimalFormat("0.#########", decimalFormatSymbols);
        try {
            this.metadata = JpegMetadataReader.readMetadata((InputStream)inputStream);
            this.exifDirectory = this.metadata.getDirectory(ExifDirectory.class);
            this.iptcDirectory = this.metadata.getDirectory(IptcDirectory.class);
            this.gpsDirectory = this.metadata.getDirectory(GpsDirectory.class);
        }
        catch (JpegProcessingException jpegProcessingException) {
            this.logger.warn("error extracting metadata", (Throwable)jpegProcessingException);
        }
    }

    public void extractExif() {
        if (this.exifDirectory == null) {
            return;
        }
        this.addStringMetadataIfSet(37378, NEXIF.apertureValue, this.exifDirectory);
        this.addStringMetadataIfSet(315, NEXIF.artist, this.exifDirectory);
        this.addStringMetadataIfSet(258, NEXIF.bitsPerSample, this.exifDirectory);
        this.addStringMetadataIfSet(37379, NEXIF.brightnessValue, this.exifDirectory);
        this.addStringMetadataIfSet(33432, NEXIF.copyright, this.exifDirectory);
        this.addStringMetadataIfSet(40963, NEXIF.height, this.exifDirectory);
        this.addStringMetadataIfSet(40962, NEXIF.width, this.exifDirectory);
        this.addStringMetadataIfSet(37380, NEXIF.exposureBiasValue, this.exifDirectory);
        this.addStringMetadataIfSet(41493, NEXIF.exposureIndex, this.exifDirectory);
        this.addStringMetadataIfSet(41986, NEXIF.exposureMode, this.exifDirectory);
        this.addStringMetadataIfSet(34850, NEXIF.exposureProgram, this.exifDirectory);
        this.addStringMetadataIfSet(34850, NEXIF.exposureProgram, this.exifDirectory);
        this.addStringMetadataIfSet(33434, NEXIF.exposureTime, this.exifDirectory);
        this.addStringMetadataIfSet(37385, NEXIF.flash, this.exifDirectory);
        this.addStringMetadataIfSet(37387, NEXIF.flashEnergy, this.exifDirectory);
        this.addStringMetadataIfSet(40960, NEXIF.flashpixVersion, this.exifDirectory);
        this.addStringMetadataIfSet(271, NEXIF.make, this.exifDirectory);
    }

    private void addStringMetadataIfSet(int n, URI uRI, Directory directory) {
        String string = directory.getString(n);
        if (string != null) {
            this.result.add(uRI, string);
        }
    }

    private double getRationalArrayValue(int n, Directory directory) {
        if (!directory.containsTag(n)) {
            return Double.NaN;
        }
        try {
            Rational[] rationalArray = directory.getRationalArray(n);
            double d = rationalArray[0].doubleValue() + rationalArray[1].doubleValue() / 60.0 + rationalArray[2].doubleValue() / 3600.0;
            return d;
        }
        catch (MetadataException metadataException) {
            return Double.NaN;
        }
    }

    public void extractIPTC() {
    }

    public void extractGPS() {
        String string;
        double d;
        if (this.gpsDirectory == null) {
            return;
        }
        String string2 = this.gpsDirectory.getString(4);
        String string3 = this.gpsDirectory.getString(2);
        String string4 = this.gpsDirectory.getString(6);
        if (string2 == null && string3 == null && string4 == null) {
            return;
        }
        Model model = this.result.getModel();
        Resource resource = UriUtil.generateRandomResource(model);
        this.result.add(NEXIF.gps, (Node)resource);
        model.addStatement(resource, RDF.type, (Node)GEO.Point);
        if (string4 != null) {
            d = this.getRationalArrayValue(6, this.gpsDirectory);
            model.addStatement(resource, GEO.alt, this.degreesFormat.format(d));
        }
        if (string2 != null) {
            d = this.getRationalArrayValue(4, this.gpsDirectory);
            string = this.gpsDirectory.getString(3);
            if (string != null && string.equalsIgnoreCase("W")) {
                d = -d;
            }
            model.addStatement(resource, GEO.long_, this.degreesFormat.format(d));
        }
        if (string3 != null) {
            d = this.getRationalArrayValue(2, this.gpsDirectory);
            string = this.gpsDirectory.getString(1);
            if (string != null && string.equalsIgnoreCase("S")) {
                d = -d;
            }
            model.addStatement(resource, GEO.lat, this.degreesFormat.format(d));
        }
    }
}

