/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustdecider.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class CertificateDialog {
    private JTable table;
    private JTextArea textArea;
    private Object[] msg;
    private Object[] options;

    public CertificateDialog(Certificate[] certificateArray) {
        if (certificateArray.length > 0 && certificateArray[0] instanceof X509Certificate) {
            Serializable serializable;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            for (int i = 0; i < certificateArray.length; ++i) {
                serializable = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)certificateArray[i]));
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = serializable;
                    defaultMutableTreeNode2 = serializable;
                    continue;
                }
                defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
                defaultMutableTreeNode2 = serializable;
            }
            final JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.getSelectionModel().setSelectionMode(1);
            jTree.putClientProperty("JTree.lineStyle", "Angled");
            jTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                        CertificateDialog.this.showCertificate(certificateInfo.getCertificate());
                    }
                }
            });
            serializable = new JScrollPane(jTree);
            ((JComponent)serializable).setPreferredSize(new Dimension(200, 100));
            JLabel jLabel = new JLabel("Certificate chain:");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)serializable, "Center");
            jPanel.add((Component)jLabel, "North");
            this.table = new JTable();
            this.table.setSelectionMode(0);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = CertificateDialog.this.table.getSelectedRow();
                    if (n >= 0) {
                        String string = (String)CertificateDialog.this.table.getValueAt(n, 1);
                        CertificateDialog.this.textArea.setText(string);
                    }
                }
            });
            Dimension dimension = this.table.getPreferredScrollableViewportSize();
            dimension.setSize(dimension.getWidth(), 120.0);
            this.table.setPreferredScrollableViewportSize(dimension);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(false);
            this.textArea.setEditable(false);
            this.textArea.setColumns(40);
            this.textArea.setFont(new Font("monospaced", 0, 12));
            JScrollPane jScrollPane2 = new JScrollPane(this.textArea);
            JLabel jLabel2 = new JLabel("Selected certificate contents:");
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel2.add((Component)jScrollPane2, "South");
            jPanel2.add((Component)jLabel2, "North");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add(Box.createHorizontalStrut(25), "Center");
            jPanel3.add((Component)jPanel2, "East");
            this.msg = new Object[]{jPanel3};
            final JButton jButton = new JButton("Close");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    while (component != null) {
                        if (!((component = component.getParent()) instanceof JOptionPane)) continue;
                        ((JOptionPane)component).setValue(jButton);
                        break;
                    }
                }
            });
            this.options = new Object[]{jButton};
            this.showCertificate((X509Certificate)certificateArray[0]);
        }
    }

    public void show(Component component) {
        JOptionPane.showOptionDialog(component, this.msg, "Certificate Info", -1, -1, null, this.options, this.options[0]);
    }

    private String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (c == ',' && !bl) {
                stringBuilder.append(",\n");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void showCertificate(X509Certificate x509Certificate) {
        String string = "V" + x509Certificate.getVersion();
        String string2 = "[" + x509Certificate.getSerialNumber() + "]";
        String string3 = "[" + x509Certificate.getSigAlgName() + "]";
        String string4 = this.formatDNString(((Object)x509Certificate.getIssuerDN()).toString());
        String string5 = "[From: " + x509Certificate.getNotBefore() + ",\n To: " + x509Certificate.getNotAfter() + "]";
        String string6 = this.formatDNString(((Object)x509Certificate.getSubjectDN()).toString());
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string7 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        Object[][] objectArray = new String[][]{{"Version", string}, {"Serial Number", string2}, {"Signature Algorithm", string3}, {"Issuer", string4}, {"Validity", string5}, {"Subject", string6}, {"Signature", string7}};
        Object[] objectArray2 = new String[]{"Field", "Value"};
        this.table.setModel(new DefaultTableModel(objectArray, objectArray2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        this.table.setRowSelectionInterval(6, 6);
    }

    private static class CertificateInfo {
        private X509Certificate cert;

        CertificateInfo(X509Certificate x509Certificate) {
            this.cert = x509Certificate;
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }

        private String extractAliasName(X509Certificate x509Certificate) {
            String string = "Unknown subject";
            String string2 = "Unknown issuer";
            try {
                Principal principal = x509Certificate.getSubjectDN();
                Principal principal2 = x509Certificate.getIssuerDN();
                String string3 = principal.getName();
                String string4 = principal2.getName();
                string = this.extractFromQuote(string3, "CN=");
                if (string == null) {
                    string = this.extractFromQuote(string3, "O=");
                }
                if (string == null) {
                    string = "Unknown subject";
                }
                if ((string2 = this.extractFromQuote(string4, "CN=")) == null) {
                    string2 = this.extractFromQuote(string4, "O=");
                }
                if (string2 == null) {
                    string2 = "Unknown issuer";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string + " (" + string2 + ")";
        }

        private String extractFromQuote(String string, String string2) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf(string2);
            int n2 = 0;
            if (n >= 0) {
                if ((n2 = string.charAt(n += string2.length()) == '\"' ? string.indexOf(34, ++n) : string.indexOf(44, n)) < 0) {
                    return string.substring(n);
                }
                return string.substring(n, n2);
            }
            return null;
        }

        public String toString() {
            return this.extractAliasName(this.cert);
        }
    }

    private static class HexDumpEncoder {
        private static final int BYTES_PER_LINE = 16;
        private static final int BYTES_PER_ATOM = 1;
        private int offset;
        private int thisLineLength;
        private int currentByte;
        private byte[] thisLine = new byte[16];
        private PrintStream pStream;

        private HexDumpEncoder() {
        }

        public String encodeBuffer(byte[] byArray) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.encodeBuffer(byteArrayInputStream, byteArrayOutputStream);
            }
            catch (Exception exception) {
                throw new Error("encodeBuffer internal error");
            }
            return byteArrayOutputStream.toString();
        }

        private void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
            int n;
            byte[] byArray = new byte[16];
            this.encodeBufferPrefix(outputStream);
            while ((n = this.readFully(inputStream, byArray)) != 0) {
                this.encodeLinePrefix(outputStream, n);
                for (int i = 0; i < n; ++i) {
                    if (i + 1 <= n) {
                        this.encodeAtom(outputStream, byArray, i, 1);
                        continue;
                    }
                    this.encodeAtom(outputStream, byArray, i, n - i);
                }
                this.encodeLineSuffix(outputStream);
                if (n >= 16) continue;
                break;
            }
        }

        private void encodeBufferPrefix(OutputStream outputStream) throws IOException {
            this.offset = 0;
            this.pStream = new PrintStream(outputStream);
        }

        private int readFully(InputStream inputStream, byte[] byArray) throws IOException {
            for (int i = 0; i < byArray.length; ++i) {
                int n = inputStream.read();
                if (n == -1) {
                    return i;
                }
                byArray[i] = (byte)n;
            }
            return byArray.length;
        }

        private void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
            this.hexDigit((byte)(this.offset >>> 8 & 0xFF));
            this.hexDigit((byte)(this.offset & 0xFF));
            this.pStream.print(": ");
            this.currentByte = 0;
            this.thisLineLength = n;
        }

        private void hexDigit(byte by) {
            char c = (char)(by >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
            this.pStream.write(c);
            c = (char)(by & 0xF);
            c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
            this.pStream.write(c);
        }

        private void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
            this.thisLine[this.currentByte] = byArray[n];
            this.hexDigit(byArray[n]);
            this.pStream.print(" ");
            ++this.currentByte;
            if (this.currentByte == 8) {
                this.pStream.print("  ");
            }
        }

        private void encodeLineSuffix(OutputStream outputStream) throws IOException {
            int n;
            if (this.thisLineLength < 16) {
                for (n = this.thisLineLength; n < 16; ++n) {
                    this.pStream.print("   ");
                    if (n != 7) continue;
                    this.pStream.print("  ");
                }
            }
            this.pStream.print(" ");
            for (n = 0; n < this.thisLineLength; ++n) {
                if (this.thisLine[n] < 32 || this.thisLine[n] > 122) {
                    this.pStream.print(".");
                    continue;
                }
                this.pStream.write(this.thisLine[n]);
            }
            this.pStream.println();
            this.offset += this.thisLineLength;
        }
    }
}

