/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleMerger {
    public static final String MANIFEST_OPTION = "-m";
    public static final String OUTPUT_OPTION = "-o";
    private static final Object ACTIVATOR_OPTION = "-a";
    private Manifest outputManifest;
    private File outputFile;
    private List<JarFile> inputJarFiles = new LinkedList<JarFile>();
    private List<String> classesToAdd = new LinkedList<String>();

    public void setOutputManifest(Manifest manifest) throws FileNotFoundException {
        this.outputManifest = manifest;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    public void addInputJarFile(JarFile jarFile) {
        this.inputJarFiles.add(jarFile);
    }

    public void addClass(String string) {
        this.classesToAdd.add(string);
    }

    public void doMerge() throws Exception {
        Class<?> clazz;
        if (this.outputManifest == null) {
            throw new Exception("Manifest not specified");
        }
        if (this.outputFile == null) {
            throw new Exception("Output file not specified");
        }
        if (this.inputJarFiles.size() == 0) {
            throw new Exception("No input jars specified");
        }
        for (String object2 : this.classesToAdd) {
            clazz = Class.forName(object2);
            if (clazz != null) continue;
            throw new Exception("Couldn't find the class: " + object2);
        }
        List<Manifest> list = this.gatherManifests(this.inputJarFiles);
        Set<String> set = this.gatherValues(list, "Import-Package");
        System.out.println(this.setToString(set));
        this.removeSelfProvidedImports(set, this.inputJarFiles);
        System.out.println(this.setToString(set));
        clazz = this.gatherValues(list, "Export-Package");
        Set<String> set2 = this.gatherValues(list, "Bundle-Classpath");
        System.out.println(this.setToString((Set<String>)((Object)clazz)));
        System.out.println(this.setToString(set2));
        this.outputManifest.getMainAttributes().putValue("Import-Package", this.setToString(set));
        this.outputManifest.getMainAttributes().putValue("Export-Package", this.setToString((Set<String>)((Object)clazz)));
        this.outputManifest.getMainAttributes().putValue("Bundle-Classpath", this.setToString(set2));
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.outputFile), this.outputManifest);
        this.addFilesToJar(this.inputJarFiles, jarOutputStream);
    }

    private void removeSelfProvidedImports(Set<String> set, List<JarFile> list) {
        for (JarFile jarFile : list) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.getName().contains("META-INF") || jarEntry.isDirectory()) continue;
                String string = jarEntry.getName();
                string = string.replaceAll("/", ".");
                if ((string = string.substring(0, string.lastIndexOf("."))).lastIndexOf("$") != -1) {
                    string = string.substring(0, string.lastIndexOf("$"));
                }
                string = string.substring(0, string.lastIndexOf("."));
                set.remove(string);
            }
        }
    }

    private void addFilesToJar(List<JarFile> list, JarOutputStream jarOutputStream) throws Exception {
        byte[] byArray = new byte[1024];
        for (String object : this.classesToAdd) {
            this.addClassToJar(object, jarOutputStream);
        }
        for (JarFile jarFile : list) {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.getName().contains("META-INF") || jarEntry.isDirectory()) continue;
                jarOutputStream.putNextEntry(jarEntry);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                while ((n = inputStream.read(byArray)) != -1) {
                    jarOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
            }
        }
        jarOutputStream.close();
    }

    private void addClassToJar(String string, JarOutputStream jarOutputStream) throws Exception {
        int n;
        String string2 = string.replaceAll("\\.", "/") + ".class";
        File file = new File(ClassLoader.getSystemResource(string2).toString());
        JarEntry jarEntry = new JarEntry(string2);
        jarEntry.setSize(file.length());
        jarEntry.setTime(file.lastModified());
        jarEntry.setMethod(8);
        jarOutputStream.putNextEntry(jarEntry);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            jarOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
    }

    public List<Manifest> gatherManifests(List<JarFile> list) throws IOException {
        Iterator<JarFile> iterator = list.iterator();
        LinkedList<Manifest> linkedList = new LinkedList<Manifest>();
        while (iterator.hasNext()) {
            JarFile jarFile = iterator.next();
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) continue;
            linkedList.add(manifest);
        }
        return linkedList;
    }

    private Set<String> gatherValues(List<Manifest> list, String string) {
        Iterator<Manifest> iterator = list.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            Manifest manifest = iterator.next();
            String string2 = manifest.getMainAttributes().getValue(string);
            if (string2 == null) continue;
            String[] stringArray = string2.split(", ");
            for (int i = 0; i < stringArray.length; ++i) {
                treeSet.add(stringArray[i]);
            }
        }
        return treeSet;
    }

    private String setToString(Set<String> set) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : set) {
            if (bl) {
                stringBuffer.append(string);
                bl = false;
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        BundleMerger bundleMerger = new BundleMerger();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string = stringArray[i];
            if (string.equals(MANIFEST_OPTION)) {
                object2 = stringArray[++i];
                object = new Manifest(new FileInputStream(new File((String)object2)));
                bundleMerger.setOutputManifest((Manifest)object);
                continue;
            }
            if (string.equals(OUTPUT_OPTION)) {
                object2 = stringArray[++i];
                object = new File((String)object2);
                bundleMerger.setOutputFile((File)object);
                continue;
            }
            if (string.equals(ACTIVATOR_OPTION)) {
                object2 = stringArray[++i];
                bundleMerger.addClass((String)object2);
                continue;
            }
            object2 = new JarFile(stringArray[i]);
            bundleMerger.addInputJarFile((JarFile)object2);
        }
        bundleMerger.doMerge();
    }
}

