/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjectBase
implements DataObject {
    private URI id;
    private DataSource dataSource;
    private RDFContainer metadata;
    private boolean disposed;

    public DataObjectBase() {
    }

    public DataObjectBase(URI uRI, DataSource dataSource, RDFContainer rDFContainer) {
        this.id = uRI;
        this.dataSource = dataSource;
        this.metadata = rDFContainer;
        this.disposed = false;
        rDFContainer.add(RDF.type, (Node)NIE.DataObject);
    }

    public void finalize() throws Throwable {
        if (!this.disposed) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("DataObject has not been disposed. URI: " + this.id + " From DataSource: " + this.dataSource.getName() + " [" + this.dataSource.getID() + "]");
            try {
                this.dispose();
            }
            catch (Throwable throwable) {
                logger.error("Error while disposing DataObject", throwable);
            }
        }
        super.finalize();
    }

    public void setID(URI uRI) {
        this.id = uRI;
    }

    public URI getID() {
        return this.id;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setMetadata(RDFContainer rDFContainer) {
        this.metadata = rDFContainer;
    }

    public RDFContainer getMetadata() {
        return this.metadata;
    }

    public void dispose() {
        this.disposed = true;
        this.metadata.dispose();
    }
}

