/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.FileExtractorFactory;
import org.semanticdesktop.aperture.extractor.impl.ExtractorRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultExtractorRegistry
extends ExtractorRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/extractor/impl/defaults.xml";
    private static final String EXTRACTOR_FACTORY_TAG = "extractorFactory";
    private static final String NAME_TAG = "name";

    public DefaultExtractorRegistry() {
        try {
            InputStream inputStream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultExtractorRegistry.class);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.parse(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/extractor/impl/defaults.xml", iOException);
        }
    }

    public DefaultExtractorRegistry(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser();
            simpleSAXParser.setListener(new ExtractorParser());
            simpleSAXParser.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private class ExtractorParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private ExtractorParser() {
        }

        public void startTag(String string, Map map, String string2) throws SAXException {
            if (DefaultExtractorRegistry.EXTRACTOR_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = true;
            } else if (DefaultExtractorRegistry.NAME_TAG.equals(string) && this.insideFactoryElement && string2 != null) {
                this.processClassName(string2);
            }
        }

        public void endTag(String string) {
            if (DefaultExtractorRegistry.EXTRACTOR_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String string) {
            if (!(string = string.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    if (obj instanceof ExtractorFactory) {
                        ExtractorFactory extractorFactory = (ExtractorFactory)obj;
                        DefaultExtractorRegistry.this.add(extractorFactory);
                    } else if (obj instanceof FileExtractorFactory) {
                        FileExtractorFactory fileExtractorFactory = (FileExtractorFactory)obj;
                        DefaultExtractorRegistry.this.add(fileExtractorFactory);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.warn("unable to find class " + string + ", ignoring", (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.warn("unable to instantiate class " + string + ", ignoring", (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.warn("unable to access class " + string + ", ignoring", (Throwable)illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    this.logger.warn("unable to cast instance to " + ExtractorFactory.class.getName() + ", ignoring", (Throwable)classCastException);
                }
            }
        }
    }
}

