/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractor;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.EntityResolver;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.TokenHandler;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.Tokenizer;

public class HtmlLinkExtractor
implements LinkExtractor,
TokenHandler {
    private URL baseURL;
    private boolean includeEmbeddedResources;
    private ArrayList links;
    private String startTag;
    private HashMap attributes = new HashMap();

    public synchronized List extractLinks(InputStream inputStream, Map map) throws IOException {
        Tokenizer tokenizer = new Tokenizer(this);
        this.links = new ArrayList();
        this.baseURL = null;
        this.includeEmbeddedResources = false;
        Object v = map.get(BASE_URL_KEY);
        if (v instanceof URL) {
            this.baseURL = (URL)v;
        } else if (v instanceof String) {
            this.baseURL = new URL((String)v);
        }
        v = map.get(INCLUDE_EMBEDDED_RESOURCES_KEY);
        if (v instanceof Boolean) {
            this.includeEmbeddedResources = (Boolean)v;
        }
        tokenizer.read(inputStream);
        ArrayList arrayList = this.links;
        this.links = null;
        return arrayList;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startOfStartTag(String string) {
        this.startTag = string.toUpperCase();
    }

    public void endOfStartTag() {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("BASE".equals(this.startTag)) {
            string2 = (String)this.attributes.get("HREF");
            if (string2 != null) {
                try {
                    this.baseURL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if ("META".equals(this.startTag)) {
            string2 = (String)this.attributes.get("CONTENT");
            String string3 = (String)this.attributes.get("HTTP-EQUIV");
            if (string2 != null && string3 != null && string3.trim().equalsIgnoreCase("REFRESH")) {
                string = string2.toLowerCase();
                int n = string.indexOf("url");
                if (n != -1) {
                    n += 3;
                }
                int n2 = string.indexOf(44);
                int n3 = string.indexOf(59);
                int n4 = Math.max(n, n2);
                if ((n4 = Math.max(n4, n3)) != -1) {
                    string2 = string2.substring(n4 + 1);
                }
                arrayList.add(string2);
            }
        } else if ("A".equals(this.startTag)) {
            arrayList.add((String)this.attributes.get("HREF"));
        } else if ("FRAME".equals(this.startTag) || "IFRAME".equals(this.startTag)) {
            arrayList.add((String)this.attributes.get("SRC"));
            arrayList.add((String)this.attributes.get("LONGDESC"));
        } else if ("HEAD".equals(this.startTag)) {
            arrayList.add((String)this.attributes.get("PROFILE"));
        } else if ("AREA".equals(this.startTag)) {
            arrayList.add((String)this.attributes.get("HREF"));
        } else if ("Q".equals(this.startTag) || "BLOCKQUOTE".equals(this.startTag) || "INS".equals(this.startTag) || "DEL".equals(this.startTag)) {
            arrayList.add((String)this.attributes.get("CITE"));
        } else if ("LINK".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                arrayList.add((String)this.attributes.get("HREF"));
                arrayList.add((String)this.attributes.get("SRC"));
            }
        } else if ("LAYER".equals(this.startTag) || "ILAYER".equals(this.startTag)) {
            arrayList.add((String)this.attributes.get("SRC"));
            if (this.includeEmbeddedResources) {
                arrayList.add((String)this.attributes.get("BACKGROUND"));
            }
        } else if ("BODY".equals(this.startTag) || "TABLE".equals(this.startTag) || "TR".equals(this.startTag) || "TH".equals(this.startTag) || "TD".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                arrayList.add((String)this.attributes.get("BACKGROUND"));
            }
        } else if ("IMG".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                arrayList.add((String)this.attributes.get("SRC"));
                arrayList.add((String)this.attributes.get("LOWSRC"));
            }
            arrayList.add((String)this.attributes.get("LONGDESC"));
            arrayList.add((String)this.attributes.get("USEMAP"));
        } else if ("INPUT".equals(this.startTag)) {
            if (this.includeEmbeddedResources) {
                arrayList.add((String)this.attributes.get("SRC"));
            }
            arrayList.add((String)this.attributes.get("USEMAP"));
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            string = (String)arrayList.get(i);
            if (string == null) continue;
            string = EntityResolver.resolveEntities(string);
            if (this.baseURL != null) {
                try {
                    URL uRL = new URL(this.baseURL, string);
                    string = uRL.toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.links.add(string);
        }
        this.attributes.clear();
    }

    public void endTag(String string) {
    }

    public void attribute(String string) {
    }

    public void attribute(String string, String string2) {
        this.attributes.put(string.toUpperCase(), string2);
    }

    public void text(String string) {
    }

    public void comment(String string) {
    }

    public void docType(String string, String string2, String string3, String string4) {
    }

    public void error(String string) {
    }
}

