/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

public class MagicNumber {
    private byte[] magicBytes;
    private int offset;
    private int minimumLength;

    public MagicNumber(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException("magicBytes should not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset should be >= 0");
        }
        this.magicBytes = byArray;
        this.offset = n;
        this.minimumLength = byArray.length + n;
    }

    public byte[] getMagicBytes() {
        return this.magicBytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public boolean matches(byte[] byArray, int n) {
        if (byArray.length < this.minimumLength + n) {
            return false;
        }
        int n2 = this.offset + n;
        for (int i = 0; i < this.magicBytes.length; ++i) {
            if (this.magicBytes[i] == byArray[i + n2]) continue;
            return false;
        }
        return true;
    }
}

