/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.OWL;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VocabularyWriter {
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    public static final Set<String> JAVA_RESERVED_WORDS_SET = VocabularyWriter.prepareJavaKeywordSet();
    String inputRdf = null;
    String outputDir = null;
    String outputFileN = null;
    String ns = null;
    String packagen = null;
    Model myModel = null;
    PrintStream outP;
    File inputRdfF;
    File outputDirF;
    File outputF;
    File outputOntologyFile;
    Boolean namespacestrict = false;
    Syntax syntax;
    HashMap<String, String> uriToLocalName = new HashMap();
    private boolean forceGeneration = false;

    private static Set<String> prepareJavaKeywordSet() {
        HashSet<String> hashSet = new HashSet<String>(100);
        for (String string : JAVA_RESERVED_WORDS) {
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void go(String[] stringArray) throws Exception {
        this.getOpt(stringArray);
        if (this.ontologyUpToDate()) {
            return;
        }
        this.loadOnt();
        this.writeVocab();
    }

    private boolean ontologyUpToDate() {
        if (this.outputF.canRead() && !this.forceGeneration) {
            long l = this.inputRdfF.lastModified();
            long l2 = this.outputF.lastModified();
            return l2 >= l;
        }
        return false;
    }

    private void loadOnt() throws Exception {
        this.myModel = RDF2Go.getModelFactory().createModel();
        this.myModel.open();
        this.syntax = this.getSyntax(this.inputRdf);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.inputRdfF));
        this.myModel.readFrom((Reader)bufferedReader, this.syntax);
        ((Reader)bufferedReader).close();
        this.copyFile(this.inputRdfF, this.outputOntologyFile);
    }

    private Syntax getSyntax(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return Syntax.RdfXml;
        }
        String string2 = string.substring(n + 1);
        if ("rdf".equals(string2) || "rdfs".equals(string2) || "owl".equals(string2)) {
            return Syntax.RdfXml;
        }
        if ("ttl".equals(string2) || "nt".equals(string2) || "n3".equals(string2)) {
            return Syntax.Turtle;
        }
        if ("trix".equals(string2)) {
            return Syntax.Trix;
        }
        if ("trig".equals(string2)) {
            return Syntax.Trig;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file, File file2) {
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
                return;
            }
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            int n = 0;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            this.closeStream(fileInputStream);
            this.closeStream(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.closeStream(fileInputStream);
            this.closeStream(fileOutputStream);
        }
    }

    private void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVocab() throws Exception {
        this.outP = new PrintStream(this.outputF);
        try {
            this.outP.println("package " + this.packagen + ";");
            this.outP.println("import java.io.InputStream;");
            this.outP.println("import java.io.FileNotFoundException;");
            this.outP.println("import org.ontoware.rdf2go.model.Model;");
            this.outP.println("import org.ontoware.rdf2go.model.Syntax;");
            this.outP.println("import org.ontoware.rdf2go.model.node.URI;");
            this.outP.println("import org.ontoware.rdf2go.model.node.impl.URIImpl;");
            this.outP.println("import org.semanticdesktop.aperture.util.ResourceUtil;");
            this.outP.println("/**");
            this.outP.println(" * Vocabulary File. Created by " + VocabularyWriter.class.getName() + " on " + new Date());
            this.outP.println(" * input file: " + this.inputRdf);
            this.outP.println(" * namespace: " + this.ns);
            this.outP.println(" */");
            this.outP.println("public class " + this.outputFileN + " {");
            this.outP.println();
            this.outP.println("    /** Path to the ontology resource */");
            this.outP.println("    public static final String " + this.outputFileN + "_RESOURCE_PATH = ");
            this.outP.print("      " + this.outputFileN + ".class.getPackage().getName().replace('.', '/') + ");
            this.outP.println("\"/" + this.inputRdfF.getName() + "\";");
            this.outP.println();
            this.writeGetOntologyMethod();
            this.outP.println();
            this.outP.println("    /** The namespace for " + this.outputFileN + " */");
            this.outP.println("    public static final URI NS_" + this.outputFileN + " = new URIImpl(\"" + this.ns + "\");");
            this.generateElement(RDFS.Class, false);
            this.generateElement(OWL.Class, false);
            this.generateElement(RDF.Property, true);
            this.generateElement(OWL.DatatypeProperty, true);
            this.generateElement(OWL.ObjectProperty, true);
            this.outP.println("}");
        }
        finally {
            this.outP.close();
        }
        System.out.println("successfully wrote file to " + this.outputF);
    }

    private void writeGetOntologyMethod() {
        this.outP.println("    /**");
        this.outP.println("     * Puts the " + this.outputFileN + " ontology into the given model.");
        this.outP.println("     * @param model The model for the source ontology to be put into.");
        this.outP.println("     * @throws Exception if something goes wrong.");
        this.outP.println("     */");
        this.outP.println("    public static void get" + this.outputFileN + "Ontology(Model model) {");
        this.outP.println("        try {");
        this.outP.println("            InputStream stream = ResourceUtil.getInputStream(" + this.outputFileN + "_RESOURCE_PATH, " + this.outputFileN + ".class);");
        this.outP.println("            if (stream == null) {");
        this.outP.println("                throw new FileNotFoundException(\"couldn't find resource \" + " + this.outputFileN + "_RESOURCE_PATH);");
        this.outP.println("             }");
        this.outP.println("            model.readFrom(stream, Syntax." + this.getSyntaxName() + ");");
        this.outP.println("        } catch(Exception e) {");
        this.outP.println("             throw new RuntimeException(e);");
        this.outP.println("        }");
        this.outP.println("    }");
    }

    private String getSyntaxName() {
        if (this.syntax.equals((Object)Syntax.RdfXml)) {
            return "RdfXml";
        }
        if (this.syntax.equals((Object)Syntax.Ntriples)) {
            return "Ntriples";
        }
        if (this.syntax.equals((Object)Syntax.Trig)) {
            return "Trig";
        }
        if (this.syntax.equals((Object)Syntax.Trix)) {
            return "Trix";
        }
        if (this.syntax.equals((Object)Syntax.Turtle)) {
            return "Turtle";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateElement(URI uRI, boolean bl) throws Exception {
        ClosableIterator closableIterator = this.myModel.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDF.type, (NodeOrVariable)uRI);
        LinkedList<URI> linkedList = new LinkedList<URI>();
        try {
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Resource resource = statement.getSubject();
                if (!(resource instanceof URI)) continue;
                URI uRI2 = (URI)resource;
                String string = uRI2.toString();
                String string2 = this.getLocalName(uRI2);
                String string3 = this.asLegalJavaID(string2, false);
                if (this.uriToLocalName.containsKey(string)) continue;
                this.uriToLocalName.put(string, string3);
                if (this.namespacestrict.booleanValue() && !string.startsWith(this.ns)) continue;
                this.outP.println("    /**");
                this.printCommentAndLabel(uRI2);
                this.outP.println("     */");
                this.outP.println("    public static final URI " + string3 + " = new URIImpl(\"" + string + "\");");
                linkedList.add(uRI2);
            }
        }
        finally {
            closableIterator.close();
        }
        for (URI uRI3 : linkedList) {
            this.generateElement(uRI3, false);
        }
    }

    private String getLocalName(URI uRI) {
        String string = uRI.toString();
        int n = string.indexOf(35);
        if (n < 0) {
            n = string.lastIndexOf(47);
        }
        if (n < 0) {
            n = string.lastIndexOf(58);
        }
        if (n < 0) {
            throw new RuntimeException("Not a legal (absolute) URI: " + string);
        }
        return string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCommentAndLabel(URI uRI) throws Exception {
        ClosableIterator closableIterator = this.myModel.findStatements((ResourceOrVariable)uRI, (UriOrVariable)RDF.type, (NodeOrVariable)Variable.ANY);
        try {
            String string = "";
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Node node = statement.getObject();
                if (node instanceof URI) {
                    URI uRI2 = (URI)node;
                    if (node.equals(RDFS.Class)) {
                        string = "Class";
                        continue;
                    }
                    if (node.equals(RDF.Property)) {
                        string = "Property";
                        continue;
                    }
                    string = "Instance of " + node.toString();
                    continue;
                }
                string = string + node.toString() + " ";
            }
            if (string.length() > 0) {
                this.outP.println("     * Type: " + string + " <br/>");
            }
        }
        finally {
            closableIterator.close();
        }
        this.addJavadocLine(uRI, RDFS.label, "Label");
        this.addJavadocLine(uRI, RDFS.comment, "Comment");
        this.addJavadocLine(uRI, RDFS.domain, "Domain");
        this.addJavadocLine(uRI, RDFS.range, "Range");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJavadocLine(URI uRI, URI uRI2, String string) {
        ClosableIterator closableIterator = this.myModel.findStatements((ResourceOrVariable)uRI, (UriOrVariable)uRI2, (NodeOrVariable)Variable.ANY);
        try {
            String string2 = "";
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Node node = statement.getObject();
                string2 = string2 + node.toString() + " ";
            }
            if (string2.length() > 0) {
                this.outP.println("     * " + string + ": " + string2 + " <br/>");
            }
        }
        finally {
            closableIterator.close();
        }
    }

    public void getOpt(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            this.help();
            throw new Exception("no arguments given");
        }
        for (int i = 0; i < stringArray.length && stringArray[i].startsWith("-"); ++i) {
            if (stringArray[i].equals("-i")) {
                this.inputRdf = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-o")) {
                this.outputDir = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-a")) {
                this.ns = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-n")) {
                this.outputFileN = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--package")) {
                this.packagen = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-f")) {
                this.forceGeneration = true;
                continue;
            }
            if (stringArray[i].equals("-namespacestrict")) {
                String string;
                if ("false".equals(string = stringArray[++i])) {
                    this.namespacestrict = false;
                    continue;
                }
                if ("true".equals(string)) {
                    this.namespacestrict = true;
                    continue;
                }
                throw new Exception("namespacestrict only allows 'true' or 'false', not '" + string + "'");
            }
            throw new Exception("unknow argument " + stringArray[i]);
        }
        if (this.inputRdf == null) {
            VocabularyWriter.usage("no input file given");
        }
        if (this.outputDir == null) {
            VocabularyWriter.usage("no output dir given");
        }
        if (this.ns == null) {
            VocabularyWriter.usage("no namespace given");
        }
        if (this.outputFileN == null) {
            VocabularyWriter.usage("no output classname given");
        }
        if (this.packagen == null) {
            VocabularyWriter.usage("no package name given");
        }
        this.inputRdfF = new File(this.inputRdf);
        System.out.println("input file: " + this.inputRdf);
        if (!this.inputRdfF.canRead()) {
            VocabularyWriter.usage("cannot read the input file");
        }
        this.outputDirF = new File(this.outputDir);
        if (!this.outputDirF.canWrite()) {
            VocabularyWriter.usage("cannot write to the output directory");
        }
        this.outputF = new File(this.outputDir, this.outputFileN + ".java");
        this.outputOntologyFile = new File(this.outputDir, this.inputRdfF.getName());
    }

    private void help() {
        System.err.println("Syntax: java VocabularyWriter -i inputfile -o outputdir -a namespace -n classname --package package ");
    }

    public static void main(String[] stringArray) throws Exception {
        new VocabularyWriter().go(stringArray);
    }

    protected String asLegalJavaID(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        try {
            while (!Character.isJavaIdentifierStart(string.charAt(n))) {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("Could not identify legal Java identifier start character in '" + string + "', replacing with __");
            return "__";
        }
        stringBuilder.append(bl ? Character.toUpperCase(string.charAt(n)) : string.charAt(n));
        ++n;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuilder.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++n;
        }
        String string2 = stringBuilder.toString();
        if (JAVA_RESERVED_WORDS_SET.contains(string2)) {
            string2 = string2 + "_";
        }
        return string2;
    }

    private static void usage(String string) throws Exception {
        throw new Exception(string);
    }
}

