/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoOptions
extends DeterminableMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoOptions.class);
    private IWebdavStore _store;
    private ResourceLocks _resourceLocks;

    public DoOptions(IWebdavStore store, ResourceLocks resLocks) {
        this._store = store;
        this._resourceLocks = resLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        String tempLockOwner = "doOptions" + System.currentTimeMillis() + req.toString();
        String path = this.getRelativePath(req);
        if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
            StoredObject so = null;
            try {
                resp.addHeader("DAV", "1, 2");
                so = this._store.getStoredObject(transaction, path);
                String methodsAllowed = DoOptions.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.addHeader("MS-Author-Via", "DAV");
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            finally {
                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }
}

