/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.rdf.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.rdf.MultipleValuesException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.UpdateException;
import org.semanticdesktop.aperture.rdf.ValueFactory;
import org.semanticdesktop.aperture.rdf.impl.ValueFactoryImpl;
import org.semanticdesktop.aperture.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFContainerImpl
implements RDFContainer {
    private Logger logger = LoggerFactory.getLogger((String)RDFContainerImpl.class.getName());
    private ValueFactory valueFactory;
    private Model model;
    private URI describedUri;
    private boolean modelShared;
    private boolean disposed;

    public RDFContainerImpl(Model model, String string) {
        this.init(model, false);
        try {
            this.describedUri = this.valueFactory.createURI(string);
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    public RDFContainerImpl(Model model, URI uRI) {
        this.init(model, false);
        this.describedUri = uRI;
    }

    public RDFContainerImpl(Model model, URI uRI, boolean bl) {
        this.init(model, bl);
        this.describedUri = uRI;
    }

    public RDFContainerImpl(Model model, String string, boolean bl) {
        this.init(model, bl);
        try {
            this.describedUri = this.valueFactory.createURI(string);
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    private void init(Model model, boolean bl) {
        this.model = model;
        this.modelShared = bl;
        this.valueFactory = new ValueFactoryImpl(model);
        this.disposed = false;
    }

    public URI getDescribedUri() {
        return this.describedUri;
    }

    public Model getModel() {
        return this.model;
    }

    public void put(URI uRI, String string) {
        this.checkState();
        try {
            this.replaceInternal(uRI, (Node)this.valueFactory.createLiteral(string));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void put(URI uRI, Date date) {
        this.checkState();
        String string = DateUtil.dateTime2String(date);
        try {
            this.replaceInternal(uRI, (Node)this.valueFactory.createLiteral(string, XSD._dateTime));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void put(URI uRI, Calendar calendar) {
        this.checkState();
        this.put(uRI, calendar.getTime());
    }

    public void put(URI uRI, boolean bl) {
        this.checkState();
        try {
            this.replaceInternal(uRI, (Node)this.valueFactory.createLiteral(bl));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void put(URI uRI, int n) {
        this.checkState();
        try {
            this.replaceInternal(uRI, (Node)this.valueFactory.createLiteral(n));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void put(URI uRI, long l) {
        this.checkState();
        try {
            this.replaceInternal(uRI, (Node)this.valueFactory.createLiteral(l));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void put(URI uRI, Node node) {
        this.checkState();
        this.replaceInternal(uRI, node);
    }

    public void add(URI uRI, String string) {
        this.checkState();
        try {
            this.addInternal(uRI, (Node)this.valueFactory.createLiteral(string));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void add(URI uRI, Date date) {
        this.checkState();
        String string = DateUtil.dateTime2String(date);
        try {
            this.addInternal(uRI, (Node)this.valueFactory.createLiteral(string, XSD._dateTime));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void add(URI uRI, Calendar calendar) {
        this.checkState();
        this.add(uRI, calendar.getTime());
    }

    public void add(URI uRI, boolean bl) {
        this.checkState();
        try {
            this.addInternal(uRI, (Node)this.valueFactory.createLiteral(bl));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void add(URI uRI, int n) {
        this.checkState();
        try {
            this.addInternal(uRI, (Node)this.valueFactory.createLiteral(n));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void add(URI uRI, long l) {
        this.checkState();
        try {
            this.addInternal(uRI, (Node)this.valueFactory.createLiteral(l));
        }
        catch (ModelException modelException) {
            this.logger.error("ModelException while storing value, ignoring", (Throwable)modelException);
        }
    }

    public void add(URI uRI, Node node) {
        this.checkState();
        this.addInternal(uRI, node);
    }

    public String getString(URI uRI) {
        this.checkState();
        Node node = this.getInternal(uRI);
        if (node instanceof Literal) {
            return ((Literal)node).getValue();
        }
        return null;
    }

    public Date getDate(URI uRI) {
        this.checkState();
        String string = this.getString(uRI);
        if (string == null) {
            return null;
        }
        try {
            return DateUtil.string2DateTime(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Calendar getCalendar(URI uRI) {
        this.checkState();
        Date date = this.getDate(uRI);
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public Boolean getBoolean(URI uRI) {
        this.checkState();
        String string = this.getString(uRI);
        if (string == null) {
            return null;
        }
        return new Boolean(string);
    }

    public Integer getInteger(URI uRI) {
        this.checkState();
        String string = this.getString(uRI);
        if (string == null) {
            return null;
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Long getLong(URI uRI) {
        this.checkState();
        String string = this.getString(uRI);
        if (string == null) {
            return null;
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public URI getURI(URI uRI) {
        this.checkState();
        Node node = this.getInternal(uRI);
        if (node instanceof URI) {
            return node.asURI();
        }
        return null;
    }

    public Node getNode(URI uRI) {
        this.checkState();
        return this.getInternal(uRI);
    }

    public void remove(URI uRI) {
        this.checkState();
        Node node = this.getInternal(uRI);
        if (node != null) {
            try {
                this.model.removeStatement((Resource)this.describedUri, uRI, node);
            }
            catch (ModelRuntimeException modelRuntimeException) {
                this.logger.error("Could not remove a statement from the model", (Throwable)modelRuntimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAll(URI uRI) {
        this.checkState();
        ClosableIterator closableIterator = null;
        try {
            Statement statement;
            closableIterator = this.model.findStatements((ResourceOrVariable)this.describedUri, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            Statement statement2 = new ArrayList();
            while (closableIterator.hasNext()) {
                statement = (Statement)closableIterator.next();
                statement2.add(statement.getObject());
            }
            statement = statement2;
            return statement;
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("Could not find statements", (Throwable)modelRuntimeException);
            Collection collection = null;
            return collection;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    public void add(Statement statement) {
        this.checkState();
        try {
            this.model.addStatement(statement);
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("cannot add statement", (Throwable)modelRuntimeException);
            throw new UpdateException("cannot add statement", modelRuntimeException);
        }
    }

    public void remove(Statement statement) {
        this.checkState();
        try {
            this.model.removeStatement(statement);
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("cannot remove statement", (Throwable)modelRuntimeException);
            throw new UpdateException("cannot remove statement", modelRuntimeException);
        }
    }

    private void addInternal(URI uRI, Node node) {
        try {
            this.model.addStatement((Resource)this.describedUri, uRI, node);
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("cannot add statement", (Throwable)modelRuntimeException);
            throw new UpdateException("cannot add statement", modelRuntimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInternal(URI uRI, Node node) throws MultipleValuesException {
        try {
            ClosableIterator closableIterator = this.model.findStatements((ResourceOrVariable)this.describedUri, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            Statement statement = null;
            try {
                if (closableIterator.hasNext()) {
                    statement = (Statement)closableIterator.next();
                    if (closableIterator.hasNext()) {
                        throw new MultipleValuesException(this.describedUri, uRI);
                    }
                }
            }
            finally {
                closableIterator.close();
            }
            if (statement != null) {
                this.model.removeStatement(statement);
            }
            this.model.addStatement((Resource)this.describedUri, uRI, node);
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("cannot update statement", (Throwable)modelRuntimeException);
            throw new UpdateException("cannot update statement", modelRuntimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getInternal(URI uRI) {
        ClosableIterator closableIterator = null;
        try {
            Statement statement;
            closableIterator = this.model.findStatements((ResourceOrVariable)this.describedUri, (UriOrVariable)uRI, (NodeOrVariable)Variable.ANY);
            Statement statement2 = null;
            if (closableIterator.hasNext()) {
                statement = (Statement)closableIterator.next();
                if (closableIterator.hasNext()) {
                    throw new MultipleValuesException(this.describedUri, uRI);
                }
                statement2 = statement.getObject();
            }
            statement = statement2;
            return statement;
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("Could not find statements", (Throwable)modelRuntimeException);
            Node node = null;
            return node;
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    public ValueFactory getValueFactory() {
        this.checkState();
        return this.valueFactory;
    }

    public void dispose() {
        this.disposed = true;
        if (!this.modelShared) {
            this.model.close();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isModelShared() {
        return this.modelShared;
    }

    private void checkState() {
        if (this.disposed) {
            throw new IllegalStateException("Trying to perform an operation after disposal");
        }
    }
}

