/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.concurrent.TimeUnit;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.jboss.managed.ModeShapeManagedObject;

@ManagementObject(name="ModeShapeConnectionPool", description="A ModeShape repository connection pool", componentType=@ManagementComponent(type="ModeShape", subtype="ConnectionPool"), properties=ManagementProperties.EXPLICIT)
public final class ManagedConnectionPool
implements ModeShapeManagedObject {
    private final RepositoryConnectionPool connectionPool;

    public ManagedConnectionPool(RepositoryConnectionPool connectionPool) {
        CheckArg.isNotNull((Object)connectionPool, (String)"connectionPool");
        this.connectionPool = connectionPool;
    }

    @ManagementOperation(description="Removes all in-use connections from the pool", impact=ManagedOperation.Impact.WriteOnly)
    public boolean flush() {
        return false;
    }

    @ManagementProperty(name="Available Connections", description="The number of available connections", readOnly=true, use={ViewUse.STATISTIC})
    public int getAvailableCount() {
        return this.getMaxSize() - this.getSize();
    }

    @ManagementProperty(name="Connections Created", description="The number of connections that have been created", readOnly=true, use={ViewUse.STATISTIC})
    public long getCreatedCount() {
        return this.connectionPool.getTotalConnectionsCreated();
    }

    @ManagementProperty(name="Connections Destroyed", description="The number of connections that have been destroyed", readOnly=true, use={ViewUse.STATISTIC})
    public long getDestroyedCount() {
        return this.connectionPool.getTotalConnectionsCreated() - (long)this.getSize();
    }

    @ManagementProperty(name="Connections In-use", description="The number of connections currently being used", readOnly=true, use={ViewUse.STATISTIC})
    public int getInUseCount() {
        return this.connectionPool.getInUseCount();
    }

    @ManagementProperty(name="In-use High Water Mark", description="The in-use high water mark", readOnly=true, use={ViewUse.STATISTIC})
    public int getInUseHighWaterMark() {
        return 0;
    }

    @ManagementProperty(name="Keep Alive Time", description="The time in nanonseconds to keep an idle connection alive", readOnly=false, use={ViewUse.RUNTIME})
    public long getKeepAliveTime() {
        return this.connectionPool.getKeepAliveTime(TimeUnit.NANOSECONDS);
    }

    @ManagementProperty(name="Max Failed Attempts Before Error", description="The number of failed attempts to establish a connection before throwing an error", readOnly=false, use={ViewUse.RUNTIME})
    public int getMaxFailedAttemptsBeforeError() {
        return this.connectionPool.getMaxFailedAttemptsBeforeError();
    }

    @ManagementProperty(name="Max size", description="The maximum number of connections allowed", readOnly=false, use={ViewUse.RUNTIME})
    public int getMaxSize() {
        return this.connectionPool.getMaximumPoolSize();
    }

    @ManagementProperty(name="Min size", description="The minimum number of connections allowed", readOnly=true, use={ViewUse.CONFIGURATION})
    public int getMinSize() {
        return 0;
    }

    @ManagementProperty(name="Ping Timeout", description="The time in nanoseconds that ping should wait before timing out and failing", readOnly=false, use={ViewUse.RUNTIME})
    public long getPingTimeout() {
        return this.connectionPool.getPingTimeoutInNanos();
    }

    @ManagementProperty(name="Total Connections", description="The total number of connections (in use and available)", readOnly=true, use={ViewUse.STATISTIC})
    public int getSize() {
        return this.connectionPool.getCorePoolSize();
    }

    @ManagementProperty(name="Validate Before Use", description="Indicates if connections should be validated before being used", readOnly=false, use={ViewUse.RUNTIME})
    public boolean getValidateConnectionBeforeUse() {
        return this.connectionPool.getValidateConnectionBeforeUse();
    }

    public void setKeepAliveTime(long nanos) {
        CheckArg.isNonNegative((long)nanos, (String)"nanos");
        this.connectionPool.setKeepAliveTime(nanos, TimeUnit.NANOSECONDS);
    }

    public void setMaxFailedAttemptsBeforeError(int attempts) {
        CheckArg.isNonNegative((int)attempts, (String)"attempts");
        this.connectionPool.setMaxFailedAttemptsBeforeError(attempts);
    }

    public void setSize(int size) {
        CheckArg.isPositive((int)size, (String)"size");
        this.connectionPool.setMaximumPoolSize(size);
    }

    public void setPingTimout(long nanos) {
        CheckArg.isNonNegative((long)nanos, (String)"nanos");
        this.connectionPool.setPingTimeout(nanos, TimeUnit.NANOSECONDS);
    }

    public void setValidateConnectionBeforeUse(boolean validate) {
        this.connectionPool.setValidateConnectionBeforeUse(validate);
    }
}

