/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mail;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjectFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID_KEY = "id";
    private static final String CHILDREN_KEY = "children";
    private static final String CONTENTS_KEY = "contents";
    private DataSource source;
    private RDFContainerFactory containerFactory;
    private PartStreamFactory streamFactory;

    public List createDataObjects(MimeMessage mimeMessage, String string, URI uRI, DataSource dataSource, RDFContainerFactory rDFContainerFactory, PartStreamFactory partStreamFactory) throws MessagingException, IOException {
        this.source = dataSource;
        this.containerFactory = rDFContainerFactory;
        this.streamFactory = partStreamFactory;
        HashMap hashMap = this.handleMailPart((Part)mimeMessage, (URI)new URIImpl(string), MailUtil.getDate((Message)mimeMessage));
        ArrayList arrayList = new ArrayList();
        this.createDataObjects(hashMap, uRI, arrayList);
        RDFContainer rDFContainer = ((DataObject)arrayList.get(0)).getMetadata();
        rDFContainer.add(RDF.type, (Node)NMO.Email);
        rDFContainer.add(RDF.type, (Node)NMO.MailboxDataObject);
        String string2 = mimeMessage.getMessageID();
        if (string2 != null) {
            rDFContainer.add(NMO.messageId, string2);
        }
        return arrayList;
    }

    private HashMap handleMailPart(Part part, URI uRI, Date date) throws MessagingException, IOException {
        ContentType contentType = null;
        String string = null;
        String string2 = part.getContentType();
        if (string2 != null) {
            contentType = new ContentType(string2);
            string = this.normalizeString(contentType.getPrimaryType());
        }
        if ("multipart".equals(string)) {
            Object object = part.getContent();
            if (object instanceof Multipart) {
                return this.handleMultipart((Multipart)object, contentType, uRI, date);
            }
            this.logger.warn("multipart '" + uRI + "' does not contain a Multipart object: " + (object == null ? null : object.getClass()));
            return null;
        }
        return this.handleSinglePart(part, contentType, uRI, date, false);
    }

    private HashMap handleSinglePart(Part part, ContentType contentType, URI uRI, Date date, boolean bl) throws MessagingException, IOException {
        String string = null;
        String string2 = null;
        if (contentType != null) {
            string = this.normalizeString(contentType.getBaseType());
            string2 = this.normalizeString(contentType.getParameter("charset"));
        }
        if (string == null) {
            string = "text/plain";
        }
        if (string2 == null && "text/plain".equals(string)) {
            string2 = "us-ascii";
        }
        string2 = this.normalizeCharset(string2);
        HashMap<String, Object> hashMap = null;
        if (bl) {
            hashMap = new HashMap<String, Object>();
            hashMap.put(ID_KEY, uRI);
        } else {
            String string3;
            if ("message/rfc822".equals(string)) {
                Object object = part.getContent();
                if (object instanceof Message) {
                    Message message = (Message)object;
                    return this.handleMailPart((Part)message, uRI, MailUtil.getDate(message));
                }
                this.logger.warn("message/rfc822 part with unknown content class: " + (object == null ? null : object.getClass()));
                return null;
            }
            hashMap = new HashMap();
            hashMap.put(ID_KEY, uRI);
            hashMap.put(CONTENTS_KEY, this.streamFactory.getPartStream(part));
            if (string2 != null) {
                hashMap.put((String)NIE.characterSet, string2);
            }
            if ((string3 = part.getFileName()) != null) {
                try {
                    string3 = MimeUtility.decodeWord((String)string3);
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                hashMap.put((String)NFO.fileName, string3);
                hashMap.put((String)RDF.type, NFO.Attachment);
            }
        }
        int n = part.getSize();
        if (n >= 0) {
            hashMap.put((String)NIE.byteSize, new Integer(n));
        }
        hashMap.put((String)NIE.contentCreated, date);
        if (part instanceof Message) {
            hashMap.put((String)NIE.mimeType, "message/rfc822");
            hashMap.put((String)NMO.contentMimeType, string);
            Message message = (Message)part;
            this.addObjectIfNotNull(NMO.messageSubject, message.getSubject(), hashMap);
            this.addContactArrayIfNotNull(NMO.from, message.getFrom(), hashMap);
            this.addContactArrayIfNotNull(NMO.to, message.getRecipients(Message.RecipientType.TO), hashMap);
            this.addContactArrayIfNotNull(NMO.cc, message.getRecipients(Message.RecipientType.CC), hashMap);
            this.addContactArrayIfNotNull(NMO.bcc, message.getRecipients(Message.RecipientType.BCC), hashMap);
            hashMap.put((String)RDF.type, NMO.Email);
            if (message instanceof MimeMessage) {
                MimeMessage mimeMessage = (MimeMessage)message;
                this.addObjectIfNotNull(NMO.sender, mimeMessage.getSender(), hashMap);
            }
        } else {
            hashMap.put((String)NIE.mimeType, string);
            if (hashMap.get(RDF.type) == null) {
                hashMap.put((String)RDF.type, NMO.MimeEntity);
            }
        }
        return hashMap;
    }

    private HashMap handleMultipart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        String string = this.normalizeString(contentType.getSubType());
        if ("mixed".equals(string)) {
            return this.handleMixedPart(multipart, contentType, uRI, date);
        }
        if ("alternative".equals(string)) {
            return this.handleAlternativePart(multipart, contentType, uRI, date);
        }
        if ("digest".equals(string)) {
            return this.handleDigestPart(multipart, contentType, uRI, date);
        }
        if ("related".equals(string)) {
            return this.handleRelatedPart(multipart, contentType, uRI, date);
        }
        if ("signed".equals(string)) {
            return this.handleSignedPart(multipart, contentType, uRI, date);
        }
        if ("encrypted".equals(string)) {
            return this.handleEncryptedPart(multipart, contentType, uRI, date);
        }
        if ("report".equals(string)) {
            return this.handleReportPart(multipart, contentType, uRI, date);
        }
        if ("parallel".equals(string)) {
            return this.handleParallelPart(multipart, contentType, uRI, date);
        }
        return this.handleUnknownTypePart(multipart, contentType, uRI, date);
    }

    private HashMap handleMixedPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        HashMap hashMap;
        Object object;
        int n;
        Part part = multipart.getParent();
        if (part == null) {
            return null;
        }
        HashMap hashMap2 = this.handleSinglePart(part, contentType, uRI, date, true);
        if (hashMap2 == null) {
            return null;
        }
        String string = this.getBodyPartURIPrefix(uRI);
        int n2 = multipart.getCount();
        ArrayList arrayList = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            BodyPart bodyPart = multipart.getBodyPart(n);
            if (bodyPart == null || (object = this.handleMailPart((Part)bodyPart, (URI)(hashMap = new URIImpl(string + n)), date)) == null) continue;
            arrayList.add(object);
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            hashMap = (HashMap)arrayList.get(i);
            object = hashMap.get(NIE.mimeType);
            if (!"text/plain".equals(object) && !"text/html".equals(object)) continue;
            arrayList.remove(i);
            this.transferInfo(hashMap, hashMap2);
            break;
        }
        hashMap2.put(CHILDREN_KEY, arrayList);
        return hashMap2;
    }

    private HashMap handleAlternativePart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        int n = multipart.getCount();
        if (n == 0) {
            return null;
        }
        int n2 = this.getPartWithMimeType(multipart, "text/plain");
        if (n2 < 0) {
            n2 = this.getPartWithMimeType(multipart, "text/html");
        }
        if (n2 < 0) {
            n2 = 0;
        }
        HashMap hashMap = this.handleMailPart((Part)multipart.getBodyPart(n2), uRI, date);
        Part part = multipart.getParent();
        if (part instanceof Message) {
            HashMap hashMap2 = this.handleSinglePart(part, contentType, uRI, date, true);
            if (hashMap2 == null) {
                return hashMap;
            }
            this.transferInfo(hashMap, hashMap2);
            return hashMap2;
        }
        return hashMap;
    }

    private HashMap handleDigestPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        Part part = multipart.getParent();
        if (part == null) {
            return null;
        }
        HashMap hashMap = this.handleSinglePart(part, contentType, uRI, date, true);
        if (hashMap == null) {
            return null;
        }
        String string = this.getBodyPartURIPrefix(uRI);
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            URIImpl uRIImpl;
            HashMap hashMap2;
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (bodyPart == null || (hashMap2 = this.handleMailPart((Part)bodyPart, (URI)(uRIImpl = new URIImpl(string + i)), date)) == null) continue;
            arrayList.add(hashMap2);
        }
        hashMap.put(CHILDREN_KEY, arrayList);
        return hashMap;
    }

    private HashMap handleRelatedPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        Object object;
        Part part = multipart.getParent();
        if (part == null) {
            return null;
        }
        HashMap hashMap = this.handleSinglePart(part, contentType, uRI, date, true);
        if (hashMap == null) {
            return null;
        }
        String string = this.getBodyPartURIPrefix(uRI);
        int n = 0;
        int n2 = multipart.getCount();
        String string2 = contentType.getParameter("start");
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            for (int i = 0; i < n2; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                object = this.getHeader((Part)bodyPart, "Content-ID");
                if (!string2.equals(object)) continue;
                n = i;
                break;
            }
        }
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        for (int i = 0; i < n2; ++i) {
            URIImpl uRIImpl;
            object = multipart.getBodyPart(i);
            HashMap hashMap2 = this.handleMailPart((Part)object, (URI)(uRIImpl = new URIImpl(string + i)), date);
            if (hashMap2 == null) continue;
            if (i == n) {
                this.transferInfo(hashMap2, hashMap);
                continue;
            }
            arrayList.add(hashMap2);
        }
        hashMap.put(CHILDREN_KEY, arrayList);
        return hashMap;
    }

    private HashMap handleSignedPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        return this.handleProtectedPart(multipart, 0, contentType, uRI, date);
    }

    private HashMap handleEncryptedPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        return this.handleProtectedPart(multipart, 1, contentType, uRI, date);
    }

    private HashMap handleProtectedPart(Multipart multipart, int n, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        HashMap hashMap = null;
        if (multipart.getCount() >= 2) {
            hashMap = this.handleMailPart((Part)multipart.getBodyPart(n), uRI, date);
        } else {
            this.logger.warn("multipart/signed or multipart/encrypted without enough body parts, uri = " + uRI);
        }
        Part part = multipart.getParent();
        if (part instanceof Message) {
            HashMap hashMap2 = this.handleSinglePart(part, contentType, uRI, date, true);
            if (hashMap2 == null) {
                return hashMap;
            }
            if (hashMap != null) {
                this.transferInfo(hashMap, hashMap2);
            }
            return hashMap2;
        }
        return hashMap;
    }

    private HashMap handleReportPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        HashMap hashMap;
        Part part = multipart.getParent();
        if (part == null) {
            return null;
        }
        HashMap hashMap2 = this.handleSinglePart(part, contentType, uRI, date, true);
        if (hashMap2 == null) {
            return null;
        }
        int n = multipart.getCount();
        if (n > 0 && (hashMap = this.handleMailPart((Part)multipart.getBodyPart(0), uRI, date)) != null) {
            this.transferInfo(hashMap, hashMap2);
        }
        if (n > 2) {
            hashMap = new URIImpl(this.getBodyPartURIPrefix(uRI) + "0");
            HashMap hashMap3 = this.handleMailPart((Part)multipart.getBodyPart(2), (URI)hashMap, date);
            if (hashMap3 != null) {
                ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
                arrayList.add(hashMap3);
                hashMap2.put(CHILDREN_KEY, arrayList);
            }
        }
        return hashMap2;
    }

    private HashMap handleParallelPart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        return this.handleMixedPart(multipart, contentType, uRI, date);
    }

    private HashMap handleUnknownTypePart(Multipart multipart, ContentType contentType, URI uRI, Date date) throws MessagingException, IOException {
        this.logger.warn("Unknown multipart MIME type: \"" + contentType.getBaseType() + "\", treating as multipart/mixed");
        return this.handleMixedPart(multipart, contentType, uRI, date);
    }

    private void createDataObjects(HashMap hashMap, URI uRI, ArrayList arrayList) {
        URI uRI2 = (URI)hashMap.get(ID_KEY);
        InputStream inputStream = (InputStream)hashMap.get(CONTENTS_KEY);
        RDFContainer rDFContainer = this.containerFactory.getRDFContainer(uRI2);
        if (inputStream != null && !inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 16384);
        }
        DataObjectBase dataObjectBase = inputStream == null ? new DataObjectBase(uRI2, this.source, rDFContainer) : new FileDataObjectBase(uRI2, this.source, rDFContainer, inputStream);
        arrayList.add(dataObjectBase);
        if (uRI != null) {
            rDFContainer.add(NIE.isPartOf, (Node)uRI);
        }
        this.copyString(NIE.characterSet, hashMap, rDFContainer);
        this.copyString(NIE.mimeType, hashMap, rDFContainer);
        this.copyString(NMO.contentMimeType, hashMap, rDFContainer);
        this.copyString(NMO.messageSubject, hashMap, rDFContainer);
        this.copyString(NFO.fileName, hashMap, rDFContainer);
        this.copyInt(NIE.byteSize, hashMap, rDFContainer);
        this.copyDate(NIE.contentCreated, hashMap, rDFContainer);
        this.copyAddresses(NMO.from, hashMap, rDFContainer);
        this.copyAddresses(NMO.sender, hashMap, rDFContainer);
        this.copyAddresses(NMO.to, hashMap, rDFContainer);
        this.copyAddresses(NMO.cc, hashMap, rDFContainer);
        this.copyAddresses(NMO.bcc, hashMap, rDFContainer);
        this.copyUri(RDF.type, hashMap, rDFContainer);
        rDFContainer.add(RDF.type, (Node)NMO.MimeEntity);
        ArrayList arrayList2 = (ArrayList)hashMap.get(CHILDREN_KEY);
        if (arrayList2 != null) {
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                HashMap hashMap2 = (HashMap)arrayList2.get(i);
                URI uRI3 = (URI)hashMap2.get(ID_KEY);
                rDFContainer.getModel().addStatement((Resource)uRI3, NIE.isPartOf, (Node)uRI2);
                this.createDataObjects(hashMap2, uRI2, arrayList);
            }
        }
    }

    private void copyString(URI uRI, HashMap hashMap, RDFContainer rDFContainer) {
        String string = (String)hashMap.get(uRI);
        if (string != null) {
            rDFContainer.add(uRI, string);
        }
    }

    private void copyInt(URI uRI, HashMap hashMap, RDFContainer rDFContainer) {
        Integer n = (Integer)hashMap.get(uRI);
        if (n != null) {
            rDFContainer.add(uRI, n);
        }
    }

    private void copyDate(URI uRI, HashMap hashMap, RDFContainer rDFContainer) {
        Date date = (Date)hashMap.get(uRI);
        if (date != null) {
            rDFContainer.add(uRI, date);
        }
    }

    private void copyUri(URI uRI, HashMap hashMap, RDFContainer rDFContainer) {
        URI uRI2 = (URI)hashMap.get(uRI);
        if (uRI2 != null) {
            rDFContainer.add(uRI, (Node)uRI2);
        }
    }

    private void copyAddresses(URI uRI, HashMap hashMap, RDFContainer rDFContainer) {
        Object v = hashMap.get(uRI);
        try {
            if (v instanceof InternetAddress) {
                MailUtil.addAddressMetadata((InternetAddress)v, uRI, rDFContainer);
            } else if (v instanceof InternetAddress[]) {
                InternetAddress[] internetAddressArray = (InternetAddress[])v;
                for (int i = 0; i < internetAddressArray.length; ++i) {
                    MailUtil.addAddressMetadata(internetAddressArray[i], uRI, rDFContainer);
                }
            } else if (v != null) {
                this.logger.warn("Unknown address class: " + v.getClass().getName());
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("ModelException while handling address metadata", (Throwable)modelRuntimeException);
        }
    }

    private String normalizeString(String string) {
        if (string != null) {
            string = string.trim().toLowerCase();
        }
        return string;
    }

    private String normalizeCharset(String string) {
        string = string == null || string.length() == 0 ? MimeUtility.getDefaultJavaCharset() : MimeUtility.javaCharset((String)string);
        string = string.toLowerCase();
        return string;
    }

    private void addContactArrayIfNotNull(URI uRI, Address[] addressArray, HashMap hashMap) {
        if (addressArray != null) {
            hashMap.put(uRI, addressArray);
        }
    }

    private String getBodyPartURIPrefix(URI uRI) {
        String string = uRI.toString();
        return string + (string.indexOf(35) < 0 ? "#" : "-");
    }

    private void transferInfo(HashMap hashMap, HashMap hashMap2) throws IOException {
        Object object;
        Object object2;
        Object v;
        Object v2 = hashMap.get(CONTENTS_KEY);
        if (v2 != null) {
            hashMap2.put(CONTENTS_KEY, v2);
        }
        if ((v = hashMap.get(NIE.mimeType)) != null) {
            object2 = hashMap2.get(NIE.mimeType);
            object = "message/rfc822".equals(object2) ? NMO.contentMimeType : NIE.mimeType;
            hashMap2.put(object, v);
        }
        if ((object2 = (ArrayList)hashMap.get(CHILDREN_KEY)) != null && !((ArrayList)object2).isEmpty()) {
            object = (ArrayList)hashMap2.get(CHILDREN_KEY);
            if (object == null) {
                object = new ArrayList();
                hashMap2.put(CHILDREN_KEY, object);
            }
            ((ArrayList)object).addAll(object2);
        }
    }

    private int getPartWithMimeType(Multipart multipart, String string) throws MessagingException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String string2 = this.getMimeType((Part)bodyPart);
            if (!string.equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    private String getMimeType(Part part) throws MessagingException {
        String string = part.getContentType();
        if (string != null) {
            ContentType contentType = new ContentType(string);
            return contentType.getBaseType();
        }
        return null;
    }

    private String getHeader(Part part, String string) throws MessagingException {
        String[] stringArray = part.getHeader(string);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    private void addObjectIfNotNull(URI uRI, Object object, HashMap hashMap) {
        if (object != null) {
            hashMap.put(uRI, object);
        }
    }

    public static interface PartStreamFactory {
        public InputStream getPartStream(Part var1) throws MessagingException, IOException;
    }
}

